<?php $__env->startSection('content'); ?>
    <script>
        function validarEntradaNumerica(field) {
            const campo = field;
            const valor = campo.value;
            const valorNumerico = parseFloat(valor);
    
            // Verificar si el valor ingresado es un número válido
            if (!isNaN(valorNumerico)) {
                // Verificar si el valor es mayor que 9999
                if (valorNumerico > 9999) {
                    campo.value = 9999;
                } else {
                    campo.value = valorNumerico;
                }
            } else {
                campo.value = '';
            }
        }

        $('body').on('submit','.form_guardar', function(e){
            e.preventDefault();

            formData = new FormData(document.getElementById($(this).attr('id')));
            var url = $(`#${$(this).attr('id')}`).attr('action');

            $.ajax({
                type:'POST',
                url:url,
                contentType: false,
                processData: false,
                datatype: "JSON",
                data: formData,
                beforeSend: function(){
                    $("#btn_guardar").val("Enviando..");
                    $("#btn_guardar").attr("disabled","disabled");
                }
            }).done(function (response) {
                Swal.fire({
                    icon: response.icon,
                    title: response.title,
                    text: response.text,
                });

                $(location).attr('href',response.ruta);
                console.log(response);
            }).fail(function (response) {
                console.log("fallo");
                console.log(response);

                $(".error").remove();

                $.each(response.responseJSON.errors, function (index, value) {
                    $("#" + index).after('<span class="error form-text text-danger"><b>'+value+'</b></span>');
                });
            });

            $("#btn_guardar").val("Guardar");
            $("#btn_guardar").attr("disabled",false);
        })
    </script>
    <div class="card card-custom">
        <div class="card-header card-header-tabs-line nav-tabs-line-3x">
            <div class="card-toolbar">
                <ul class="nav nav-tabs nav-bold nav-tabs-line nav-tabs-line-3x">
                    <li class="nav-item mr-3">
                        <a class="nav-link active" data-toggle="tab" href="#kt_user_edit_tab_1">
                            <span class="nav-icon">
                                <span class="svg-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <polygon points="0 0 24 0 24 24 0 24" />
                                            <path d="M12.9336061,16.072447 L19.36,10.9564761 L19.5181585,10.8312381 C20.1676248,10.3169571 20.2772143,9.3735535 19.7629333,8.72408713 C19.6917232,8.63415859 19.6104327,8.55269514 19.5206557,8.48129411 L12.9336854,3.24257445 C12.3871201,2.80788259 11.6128799,2.80788259 11.0663146,3.24257445 L4.47482784,8.48488609 C3.82645598,9.00054628 3.71887192,9.94418071 4.23453211,10.5925526 C4.30500305,10.6811601 4.38527899,10.7615046 4.47382636,10.8320511 L4.63,10.9564761 L11.0659024,16.0730648 C11.6126744,16.5077525 12.3871218,16.5074963 12.9336061,16.072447 Z" fill="#000000" fill-rule="nonzero" />
                                            <path d="M11.0563554,18.6706981 L5.33593024,14.122919 C4.94553994,13.8125559 4.37746707,13.8774308 4.06710397,14.2678211 C4.06471678,14.2708238 4.06234874,14.2738418 4.06,14.2768747 L4.06,14.2768747 C3.75257288,14.6738539 3.82516916,15.244888 4.22214834,15.5523151 C4.22358765,15.5534297 4.2250303,15.55454 4.22647627,15.555646 L11.0872776,20.8031356 C11.6250734,21.2144692 12.371757,21.2145375 12.909628,20.8033023 L19.7677785,15.559828 C20.1693192,15.2528257 20.2459576,14.6784381 19.9389553,14.2768974 C19.9376429,14.2751809 19.9363245,14.2734691 19.935,14.2717619 L19.935,14.2717619 C19.6266937,13.8743807 19.0546209,13.8021712 18.6572397,14.1104775 C18.654352,14.112718 18.6514778,14.1149757 18.6486172,14.1172508 L12.9235044,18.6705218 C12.377022,19.1051477 11.6029199,19.1052208 11.0563554,18.6706981 Z" fill="#000000" opacity="0.3" />
                                        </g>
                                    </svg>
                                </span>
                            </span>
                            <span class="nav-text font-size-lg">Reservaciones y ventas</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>

        <div class="card-body">
            <div class="tab-content">
                <div class="tab-pane show active px-7" id="kt_user_edit_tab_1" role="tabpanel">
                    <form method="POST" action="<?php echo e($editar ? route('actualizar_mesas', $mesas['id']) : route('guardar_mesa')); ?>" class="form_guardar" id="form_guardar_mesa" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row text-center">
                            <div class="col-xl-12 mb-4">
                                <div class="form-row">
                                    <div class="form-group row col-12">
                                        <label class="col-form-label col-3 text-lg-right text-left">Nombre</label>
                                        <div class="col-9">
                                            <input name="nombre" id="nombre" class="form-control form-control-lg form-control-solid" type="text" value="<?php echo e($mesas['nombre'] ?? ''); ?>"/>
                                        </div>
                                    </div>
                                    <div class="form-group row col-12">
                                        <label class="col-form-label col-3 text-lg-right text-left">Cantidad de asientos</label>
                                        <div class="col-4">
                                            <input name="cantidad" id="cantidad" class="form-control form-control-lg form-control-solid" type="text" oninput="validarEntradaNumerica(this)" value="<?php echo e($mesas['sillas'] ?? ''); ?>"/>
                                        </div>
                                    </div>
                                    <div class="form-group row col-12 mt-2">
                                        <label class="col-form-label col-3 text-lg-right text-left">Sucursal</label>
                                        <div class="col-9">
                                            <div class="row">
                                                <?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-md-3 col-sm-6 col-12 mt-2">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" name="sucursal[]" id="mesa<?php echo e($sucursal['id']); ?>" value="<?php echo e($sucursal['id']); ?>" 
                                                            <?php echo e($editar && in_array($sucursal->id, $sucursalIds) ? 'checked' : ''); ?>

                                                            >
                                                            <label class="form-check-label ml-2" for="mesa<?php echo e($sucursal['id']); ?>">
                                                                    <?php echo e($sucursal['nombre']); ?>

                                                            </label>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if($editar): ?>
                                        <div class="form-group row col-12 mt-4 mb-4">
                                            <label class="col-form-label col-3 text-lg-right text-left">Imagen del icono</label>
                                            <div class="col-8">
                                                <img src='<?php echo e(asset($mesas['icono'])); ?>' class='img-fluid' alt='icono'>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="form-group row col-12">
                                        <label class="col-form-label col-3 text-lg-right text-left">Icono</label>
                                        <div class="col-8">
                                            <input name="icono" id="icono" class="form-control form-control-lg form-control-solid" type="file" accept=".jpg, .jpeg, .png" />
                                        </div>
                                    </div>
                                    <div class="form-group row col-12 mt-2">
                                        <label class="col-form-label col-3 text-lg-right text-left">Activo</label>
                                        <div class="col-9">
                                            <div class="row">
                                                <div class="col-md-3 col-sm-6 col-12 mt-2">
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" type="radio" name="activo" id="activo1" value="1" <?php echo e(($editar) ? $mesas['activo'] ? "checked" : "" : ""); ?>>
                                                        <label class="form-check-label" for="activo1">SI</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-3 col-sm-6 col-12 mt-2">
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" type="radio" name="activo" id="activo2" value="0" <?php echo e(($editar) ? !$mesas['activo'] ? "checked" : "" : ""); ?>>
                                                        <label class="form-check-label" for="activo2">NO</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>                           
                                </div>
                            </div>

                            <div class="col-xl-12 my-2 mt-5">
                                <div class="form-group row mb-3">
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-success" id="btn_guardar"><?php echo e($editar ? "Actualizar" : "Guardar"); ?></button>
                                        <a href="<?php echo e(route('lista_mesas')); ?>" class="btn btn-danger font-weight-bolder">Cancelar</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fyiusr/public_html/qa-foliatti.itiapp.fyi/resources/views/catalogomesas/catalogomesascreate.blade.php ENDPATH**/ ?>