<?php $__env->startSection('content'); ?>
<script>
	$(document).ready(function () {
		$("#dt_lista_mesas").DataTable({
			processing: true,
			serverSide: true,
			responsive: true,
			ajax: {
				url: $("#dt_lista_mesas").data("url"),
				dataType: "json",
				type: "POST",
				data: {
					_token: $("meta[name='csrf-token'] ").attr("content"),
				},
			},
			language: {
				url: "https://cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json",
			},
			columns: [
				{
					data: "id",
				},
				{
					data: "icono",
				},
				{
					data: "nombre",
				},
				{
					data: "sillas",
				},
				{
					data: "sucursal",
				},
				{
					data: "activo",
				},
				{
					data: "opciones",
					orderable: false,
				},
			],
			order: [[0, "asc"]],
		});
    });

	//Eliminar datos de tabla
	$('body').on('click', '.btn_eliminar', function(){
		var $this = $(this);

		Swal.fire({
			title: "¿Desea eliminar?",
			text: "¿Está seguro de que desea eliminar este dato? Esta acción no se puede deshacer.",
			icon: "warning",
			showCancelButton: !0,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "Si, confirmar",
			cancelButtonText: `No, cancelar`,
			confirmButtonClass: "btn btn-primary",
			cancelButtonClass: "btn btn-danger ml-1",
			buttonsStyling: !1,
			didOpen: () => {
				document.querySelector('.swal2-html-container').style.maxHeight = '330px';
			}
		}).then(function (t) {
			t.value
				? $.ajax({
					url: $this.attr("data-route"),
					type: 'get',
				}).done(function (response) {

					Swal.fire({
						icon: response.icon,
						title: response.title,
						text: response.text
					})

					$('#'+response.dtable).DataTable().ajax.reload();
					console.log(response);
				}).fail(function (response) {
					console.log("fallo");
					console.log(response);  
					
					toastr.error("Error al enviar los datos", "Error", {
						closeButton: !0,
						tapToDismiss: !1,
						progressBar: !0,
					})
				})
			: t.dismiss === Swal.DismissReason.cancel;
		});
	})
</script>
<div class="d-flex flex-column-fluid">
	<div class="container">
		<div class="card card-custom">
			<div class="card-header flex-wrap border-0 pt-6 pb-0">
				<div class="card-title">
					<h3 class="card-label">Tipos de Mesas</h3>
				</div>
				<div class="card-toolbar">
					<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crear_catalogo_mesas')): ?>
						<a href="<?php echo e(route('crear_mesa')); ?>" class="btn btn-primary font-weight-bolder">
							<span class="svg-icon svg-icon-md">
								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
									<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
										<rect x="0" y="0" width="24" height="24" />
										<circle fill="#000000" cx="9" cy="15" r="6" />
										<path d="M8.8012943,7.00241953 C9.83837775,5.20768121 11.7781543,4 14,4 C17.3137085,4 20,6.6862915 20,10 C20,12.2218457 18.7923188,14.1616223 16.9975805,15.1987057 C16.9991904,15.1326658 17,15.0664274 17,15 C17,10.581722 13.418278,7 9,7 C8.93357256,7 8.86733422,7.00080962 8.8012943,7.00241953 Z" fill="#000000" opacity="0.3" />
									</g>
								</svg>
							</span> Nueva mesa
						</a>
					<?php endif; ?>
				</div>
			</div>

			<div class="card-body">
				<div class="table-responsive">
					<table class="table" id="dt_lista_mesas" data-url="<?php echo e(route('dt_lista_mesas')); ?>" style="width:100%">
						<thead>
							<tr>
								<th>#</th>
								<th>Icono</th>
								<th>Nombre</th>
								<th>Cantidad de sillas</th>
								<th>Sucursal</th>
								<th>Estatus</th>
								<th></th>
							</tr>
						</thead>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fyiusr/public_html/qa-foliatti.itiapp.fyi/resources/views/catalogomesas/catalogomesas.blade.php ENDPATH**/ ?>