<?php $__env->startSection('content'); ?>
<script>
	$(document).ready(function () {
		$('.js-example-basic-single').select2();

		var table = $("#dt_lista_reservacion").DataTable({
			processing: true,
			serverSide: true,
			responsive: true,
			ajax: {
				url: $("#dt_lista_reservacion").data("url"),
				dataType: "json",
				type: "POST",
				data: function (d) {
					d._token = $("meta[name='csrf-token']").attr("content");
					// Agregar datos de los filtros al payload de la solicitud
					d.tipo = $('input[name="tipo"]:checked').val();  // Obtiene el valor del botón de radio seleccionado
					d.sucursal = $('#sucursal').val();
					d.evento = $('#evento').val();
					d.fecha_ini = $('#fecha_ini').val();
					d.fecha_fin = $('#fecha_fin').val();
				},
			},
			language: {
				url: "https://cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json",
			},
			columns: [
				{ data: "evento_nombre" },
				{ data: "fecha" },
				{ data: "sucursal_nombre" },
				{ data: "opciones", orderable: false },
			],
			order: [[1, "asc"]],
		});

		$('.tipo_pago, #sucursal, #evento, #fecha_ini, #fecha_fin, input[name="tipo"]').change(function() {
			table.draw();
		});
	});

	//Eliminar datos de tabla
	$('body').on('click', '.btn_eliminar', function(){
		var $this = $(this);

		Swal.fire({
			html: $this.attr("data-mensaje"),
			icon: "warning",
			showCancelButton: !0,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "Si, confirmar",
			cancelButtonText: `No, cancelar`,
			confirmButtonClass: "btn btn-primary",
			cancelButtonClass: "btn btn-danger ml-1",
			buttonsStyling: !1,
			didOpen: () => {
				document.querySelector('.swal2-html-container').style.maxHeight = '330px';
			}
		}).then(function (t) {
			t.value
				? $.ajax({
					url: $this.attr("data-route"),
					type: 'get',
				}).done(function (response) {

					Swal.fire({
						icon: response.icon,
						title: response.title,
						text: response.text
					})

					$('#'+response.dtable).DataTable().ajax.reload();
					console.log(response);
				}).fail(function (response) {
					console.log("fallo");
					console.log(response);  
					
					toastr.error("Error al enviar los datos", "Error", {
						closeButton: !0,
						tapToDismiss: !1,
						progressBar: !0,
					})
				})
			: t.dismiss === Swal.DismissReason.cancel;
		});
	})
</script>
<div class="d-flex flex-column-fluid">
	<div class="container">
		<div class="card card-custom">
			<div class="card-header flex-wrap border-0 pt-6 pb-0">
				<div class="card-title">
					<h3 class="card-label">Reservaciones y ventas</h3>
				</div>
				<div class="card-toolbar">
					<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crear_reservacion')): ?>
						<a href="<?php echo e(route('crear_reservacion')); ?>" class="btn btn-primary font-weight-bolder">
							<span class="svg-icon svg-icon-md">
								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
									<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
										<rect x="0" y="0" width="24" height="24" />
										<circle fill="#000000" cx="9" cy="15" r="6" />
										<path d="M8.8012943,7.00241953 C9.83837775,5.20768121 11.7781543,4 14,4 C17.3137085,4 20,6.6862915 20,10 C20,12.2218457 18.7923188,14.1616223 16.9975805,15.1987057 C16.9991904,15.1326658 17,15.0664274 17,15 C17,10.581722 13.418278,7 9,7 C8.93357256,7 8.86733422,7.00080962 8.8012943,7.00241953 Z" fill="#000000" opacity="0.3" />
									</g>
								</svg>
							</span> Nueva venta
						</a>
					<?php endif; ?>
				</div>
			</div>

			<div class="card-body">
                <div class="row">
                    <div class="col-xl-12 my-2 mb-4">
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="tipo" id="reserva" value="0">
                                    <label class="form-check-label" for="reserva">Reservas</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="tipo" id="venta" value="1">
                                    <label class="form-check-label" for="venta">Ventas</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="tipo" id="todos" value="2" checked>
                                    <label class="form-check-label" for="todos">Todos</label>
                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <label for="sucursal">Sucursal</label>
                                <select class="form-control js-example-basic-single" id="sucursal" name="sucursal">
									<option value="0">-- Ver todo --</option>
                                    <?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item->id); ?>"><?php echo e($item->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-3">
                                <label for="evento">Evento</label>
                                <select class="form-control js-example-basic-single" id="evento" name="evento">
									<option value="0">-- Ver todo --</option>
                                    <?php $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item->id); ?>"><?php echo e($item->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-3">
                                <label for="fecha_ini">Fecha inicial</label>
                                <input type="date" class="form-control" id="fecha_ini" name="fecha_ini">
                            </div>
                            <div class="form-group col-md-3">
                                <label for="fecha_fin">Fecha final</label>
                                <input type="date" class="form-control" id="fecha_fin" name="fecha_fin">
                            </div>
                        </div>
                    </div>
                </div>

				<div class="table-responsive">
					<table class="table" id="dt_lista_reservacion" data-url="<?php echo e(route('dt_lista_reservacion')); ?>" style="width:100%">
						<thead>
							<tr>
								<th>Evento</th>
								<th>Fecha</th>
								<th>Sucursal</th>
								<th></th>
							</tr>
						</thead>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fyiusr/public_html/qa-foliatti.itiapp.fyi/resources/views/reservaciones/reservacion.blade.php ENDPATH**/ ?>