<?php $__env->startSection('content'); ?>
<script>
    $(document).ready(function () {
    function validarEntradaNumerica(field) {
        const campo = field;
        const valor = campo.value;
        const valorNumerico = parseFloat(valor);

        // Verificar si el valor ingresado es un número válido
        if (!isNaN(valorNumerico)) {
            // Verificar si el valor es mayor que 9999
            if (valorNumerico > 9999) {
                campo.value = 9999;
            } else {
                campo.value = valorNumerico;
            }
        } else {
            campo.value = '';
        }
    }

    // Delegación de eventos para inputs dinámicos
    $(document).on('input', 'input[name^="cantidad"]', function() {
        validarEntradaNumerica(this);
    });

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Función para calcular el total
    function calcularTotal() {
        var total = 0;

        $('input[name^="cantidad"]').each(function () {
            var cantidad = parseInt($(this).val());
            var idMesa = $(this).closest('tr').data('id');
            var sillas = parseInt($('#sillas'+idMesa).val());

            if (!isNaN(cantidad) && !isNaN(sillas)) {
                total += cantidad * sillas;
            }
        });

        var cantidadEspacio = parseInt($('#espacio').val());

        if (total > cantidadEspacio) {
            $("#btn_guardar").attr("disabled","disabled");
            $("#errorMesas").show();
        } else {
            $('#cajonesTotal').val(total);
            $("#btn_guardar").attr("disabled",false);
            $("#errorMesas").hide();
        }
    }

    // Calcula el total cuando se carga la página
    calcularTotal();

    // Calcula el total cuando se cambia el valor de un campo de cantidad
    $(document).on('input', 'input[name^="cantidad"]', function () {
        calcularTotal();
    });

    // Calcula el total cuando se cambia el valor de un campo de sillas
    $(document).on('input', 'input[name^="sillas"]', function () {
        calcularTotal();
    });

    $('#seleccionarMesas').change(function() {
        if ($(this).is(':checked')) {
            $('#ocultarMesas').show();
        } else {
            $('#ocultarMesas').hide();
        }
    });

    $('#addRow').click(function() {
        var numeroDeTr = $('#tablaEjemplo tbody tr').length;  // Contar los tr dentro del tbody
        var siguienteNumero = numeroDeTr + 1; 

        // Añadir una nueva fila al final de <tbody>
        $('#tablaSeccion tbody').append('<tr id="columnaseccion'+siguienteNumero+'"><td><input name="nombreseccion[]" type="text" class="form-control form-control-lg form-control-solid" placeholder="Nombre"></td><td><input type="color" name="colorseccion[]" class="form-control form-control-lg form-control-solid" value="#' + Math.floor(Math.random() * 16777215).toString(16) + '"></td><td><button class="btn btn-danger eliminar" data-id="columnaseccion'+siguienteNumero+'"><i class="fa fa-minus-square" aria-hidden="true"></i></button></td></tr>');
    });

    // Usar delegación para manejar clics en los botones eliminar añadidos dinámicamente
    $(document).on('click', '#tablaSeccion .eliminar', function() {
        var $this = $(this);
        $('#'+$this.data("id")).remove();
    });

    $('body').on('submit','.form_guardar', function(e){
        e.preventDefault();

        formData = new FormData(document.getElementById($(this).attr('id')));
        var url = $(`#${$(this).attr('id')}`).attr('action');

        $.ajax({
            type:'POST',
            url:url,
            contentType: false,
            processData: false,
            datatype: "JSON",
            data: formData,
            beforeSend: function(){
                $("#btn_guardar").val("Enviando..");
                $("#btn_guardar").attr("disabled","disabled");
            }
        }).done(function (response) {
            Swal.fire({
                icon: response.icon,
                title: response.title,
                text: response.text,
            });

            if(response.evento != "") {
                $(location).attr('href',response.evento);
            }
            if(response.mesa != "") {
                $('#tablaMesas tbody tr:last').before(response.contenido);
                swal.close();
            }

            console.log(response);
        }).fail(function (response) {
            console.log("fallo");
            console.log(response);

            $(".error").remove();

            $.each(response.responseJSON.errors, function (index, value) {
                $("#" + index).after('<span class="error form-text text-danger"><b>'+value+'</b></span>');
            });
        });
        
        $("#mesa_nombre").val("");
        $("#mesa_sillas").val("");
        $("#btn_guardar").val("Guardar");
        $("#btn_guardar").attr("disabled",false);
    });

    $(document).on('change', '.idSucursal', function(e){
        e.preventDefault();
        var $this = $(this);

        $.ajax({
            type: 'POST',
            url: $this.attr("data-ruta"),
            datatype: "JSON",
            data: {
                id_sucursal: $this.val()
            },
        }).done(function(response) {
            console.log(response);
            $('#tablaMesas tbody .fila-dinamica').remove();
            $('#tablaMesas tbody').prepend(response.html);
        }).fail(function(response) {
            console.log("fallo");
            console.log(response);
        });
    });
});

</script>
<style>
    div.addRow {
        line-height: 45px;
        background-color: #fff;
        padding-left: 10px;
        border-bottom: 1px solid;
        border-top: 1px solid #e5e5e5;
    }

    .dataTables_filter {
        display: none;
    }
</style>
<link data-require="datatables@*" data-semver="1.10.12" rel="stylesheet" href="//cdn.datatables.net/1.10.12/css/jquery.dataTables.min.css" />
<link rel="stylesheet" href="//cdn.datatables.net/rowreorder/1.2.0/css/rowReorder.dataTables.min.css" />
    <div class="card card-custom">
        <div class="card-header card-header-tabs-line nav-tabs-line-3x">
            <div class="card-toolbar">
                <ul class="nav nav-tabs nav-bold nav-tabs-line nav-tabs-line-3x">
                    <li class="nav-item mr-3">
                        <a class="nav-link active" data-toggle="tab" href="#kt_user_edit_tab_1">
                            <span class="nav-icon">
                                <span class="svg-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <polygon points="0 0 24 0 24 24 0 24" />
                                            <path d="M12.9336061,16.072447 L19.36,10.9564761 L19.5181585,10.8312381 C20.1676248,10.3169571 20.2772143,9.3735535 19.7629333,8.72408713 C19.6917232,8.63415859 19.6104327,8.55269514 19.5206557,8.48129411 L12.9336854,3.24257445 C12.3871201,2.80788259 11.6128799,2.80788259 11.0663146,3.24257445 L4.47482784,8.48488609 C3.82645598,9.00054628 3.71887192,9.94418071 4.23453211,10.5925526 C4.30500305,10.6811601 4.38527899,10.7615046 4.47382636,10.8320511 L4.63,10.9564761 L11.0659024,16.0730648 C11.6126744,16.5077525 12.3871218,16.5074963 12.9336061,16.072447 Z" fill="#000000" fill-rule="nonzero" />
                                            <path d="M11.0563554,18.6706981 L5.33593024,14.122919 C4.94553994,13.8125559 4.37746707,13.8774308 4.06710397,14.2678211 C4.06471678,14.2708238 4.06234874,14.2738418 4.06,14.2768747 L4.06,14.2768747 C3.75257288,14.6738539 3.82516916,15.244888 4.22214834,15.5523151 C4.22358765,15.5534297 4.2250303,15.55454 4.22647627,15.555646 L11.0872776,20.8031356 C11.6250734,21.2144692 12.371757,21.2145375 12.909628,20.8033023 L19.7677785,15.559828 C20.1693192,15.2528257 20.2459576,14.6784381 19.9389553,14.2768974 C19.9376429,14.2751809 19.9363245,14.2734691 19.935,14.2717619 L19.935,14.2717619 C19.6266937,13.8743807 19.0546209,13.8021712 18.6572397,14.1104775 C18.654352,14.112718 18.6514778,14.1149757 18.6486172,14.1172508 L12.9235044,18.6705218 C12.377022,19.1051477 11.6029199,19.1052208 11.0563554,18.6706981 Z" fill="#000000" opacity="0.3" />
                                        </g>
                                    </svg>
                                </span>
                            </span>
                            <span class="nav-text font-size-lg">Datos Layout Eventos</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>

        <div class="card-body">
            <div class="tab-content">
                <div class="tab-pane show active px-7" id="kt_user_edit_tab_1" role="tabpanel">
                    <form method="POST" action="<?php echo e($editar ? route('actualizar_layaut', $layout_evento['id']) : route('guardar_layaut')); ?>" class="form_guardar" id="form_guardar_layaut">
                        <?php echo csrf_field(); ?>
                        <div class="row text-center">
                            <div class="col-xl-1"></div>
                            <div class="col-xl-9 my-2 mb-4">
                                <div class="row">
                                    <label class="col-3"></label>
                                    <div class="col-9"></div>
                                </div>
    
                                <div class="form-group row">
                                    <label class="col-form-label col-3 text-lg-right text-left">Nombre</label>
                                    <div class="col-9">
                                        <input name="nombrelayoutevento" id="nombrelayoutevento" class="form-control form-control-lg form-control-solid" type="text" value="<?php echo e($layout_evento['nombre'] ?? ""); ?>" />
                                    </div>
                                </div>
    
                                <div class="form-group row">
                                    <label class="col-3 form-label col text-lg-right text-left">Sucursal</label>
                                    <div class="col-9">
                                        <div class="input-group input-group-lg input-group-solid" id="idSucursal">
                                            <select name="idSucursal" class="form-control form-control-lg form-control-solid idSucursal" data-ruta="<?php echo e(route('guardarmesa')); ?>">
                                                <option selected disabled>Seleccione una sucursal</option>
                                                <?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($sucursal->id); ?>" <?php echo e($editar ? ($layout_evento['idsucursal'] == $sucursal->id ? "selected" : "") : ""); ?>>
                                                        <?php echo e($sucursal->nombre); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
    
                                <div class="form-group row">
                                    <label class="col-form-label col-3 text-lg-right text-left">Espacio</label>
                                    <div class="col-9">
                                        <input name="espacio" id="espacio" class="form-control form-control-lg form-control-solid" type="text" value="<?php echo e($layout_evento['espacio'] ?? ""); ?>"  />
                                    </div>
                                </div>
    
                                <div class="form-group row">
                                    <div class="col-5">
                                        <label class="col-form-label col-3 text-lg-right text-left">Activo</label>
                                    </div>
                                    <div class="col-1 mt-2">
                                        <div class="form-group row">
                                            <input class="form-check-input" type="radio" name="flexRadioDefault" id="flexRadioDefault1" <?php echo e($editar ? ($layout_evento['status'] == 1 ? "checked" : "") : "checked"); ?>>
                                            <label class="form-check-label" for="flexRadioDefault">Sí</label>
                                        </div>
                                    </div>
                                    <div class="col-1 mt-2" id='flexRadioDefault'>
                                        <div class="form-group row">
                                            <input class="form-check-input" type="radio" name="flexRadioDefault" id="flexRadioDefault2" 
                                            <?php echo e($editar ? ($layout_evento['status'] == 0 ? "checked" : "") : ""); ?>>
                                            <label class="form-check-label" for="flexRadioDefault">No</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
    
                            <div class="col-xl-1"></div>
                            <div class="col-xl-2"></div>
                            <div class="col-xl-4">
                                <div class="form-group row">
                                    <label class="col-form-label col-3 text-lg-right text-left">Capacidad</label>
                                    <div class="col-4 mt-2">
                                        <input type="checkbox" name="seleccionarMesas" id="seleccionarMesas" <?php echo e($editar ? (count($Layout_evento_mesa) != 0 ? "checked" : "") : "checked"); ?>> Mesas <br>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-4" id="ocultarMesas" <?php echo e($editar ? (count($Layout_evento_mesa) != 0 ? "style=\"display: none\"" : "") : ""); ?> >
                                <div class="form-group row">
                                    <table class="table" id="tablaMesas">
                                        <tbody>
                                            <?php if($editar): ?>
                                                <?php $__currentLoopData = $mesas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $mesa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr data-id="<?php echo e($mesa->id); ?>">
                                                        <td><?php echo e($mesa->nombre); ?> - <?php echo e($mesa->sillas); ?> asientos</td>
                                                        <td>
                                                            <input type="hidden" name="id_mesa[]" value="<?php echo e($mesa->id); ?>">
                                                            <input type="hidden" class="sillas" name="sillas" id="sillas<?php echo e($mesa->id); ?>" value="<?php echo e($mesa->sillas); ?>">

                                                            <?php $__currentLoopData = $Layout_evento_mesa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($mesa->id == $item->idmesa): ?>
                                                                    <input minlength="1" size="1" type="textfield" name="cantidad[]" value="<?php echo e($item->cantidad); ?>" oninput="validarEntradaNumerica(this)" class="form-control form-control-lg form-control-solid"> 
                                                                    <?php break; ?>
                                                                <?php endif; ?>

                                                                <?php if($loop->last): ?>
                                                                    <input minlength="1" size="1" type="textfield" name="cantidad[]" value="0" oninput="validarEntradaNumerica(this)" class="form-control form-control-lg form-control-solid"> 
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                            <tr>
                                                <td class="text-lg-right text-left">
                                                    <b>ASIENTOS</b>
                                                </td>
                                                <td>
                                                    <input name="cajones" id="cajonesTotal" class="form-control form-control-lg form-control-solid" style='border: none' type="text" value="0" readonly />
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
    
                            <div class="col-xl-12 my-2 mt-5">
                                <div class="form-group row mb-3">
                                    <div class="col-12">
                                        <a type="button" id="addRow" class="btn btn-success">Agregar zona <i class="fa-solid fa-plus"></i></a>
                                    </div>
                                </div>

                                <div class="mt-1 mb-2" id="nombreseccion"></div>

                                <div class="form-group row" class="card-body">
                                    <div class="col-10">
                                        <table class="table border" id="tablaSeccion">
                                            <thead>
                                                <tr>
                                                    <th>Zona</th>
                                                    <th>Color</th>
                                                    <th>Borrar</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if($editar): ?>
                                                    <?php $__currentLoopData = $Layout_evento_seccion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr id="columnaseccion<?php echo e($item->id); ?>">
                                                            <td>
                                                                <input name="nombreseccion[]" type="text" class="form-control form-control-lg form-control-solid" placeholder="Nombre" value="<?php echo e($item->nombre); ?>">
                                                            </td>
                                                            <td>
                                                                <input type="color" name="colorseccion[]" class="form-control form-control-lg form-control-solid" value="<?php echo e($item->color); ?>">
                                                            </td>
                                                            <td>
                                                                <button class="btn btn-danger eliminar" data-id="columnaseccion<?php echo e($item->id); ?>">
                                                                    <i class="fa fa-minus-square" aria-hidden="tdue"></i>
                                                                </button>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-12 my-2 mt-5">
                                <div class="form-group row mb-3">
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-success" id="btn_guardar">Guardar</button>
                                        <a href="<?php echo e(route('layouteventos.index')); ?>" class="btn btn-danger font-weight-bolder">Cancelar</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('eventos.tarjetaMesa', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fyiusr/public_html/qa-foliatti.itiapp.fyi/resources/views/eventos/layout_eventos_create.blade.php ENDPATH**/ ?>