<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/', function () {
    //return view('welcome');
    //return view('login.login');
    return view('auth.login');
    //return view('User.Users_create');
	
});

Route::get('login', function () {
    //return view('welcome');
	return view('login.login');
});

Route::get('dash', function () {
    //return view('welcome');
	return view('dashboard.principal');
});

Route::post('login/inicio', 'LoginController@index');

//Route::resource("/Usuarios", "UsersController")->parameters(["Users"=>"User"]);

Route::resource("/Clientes", "ClientesController")->parameters(["Clientes"=>"Cliente"]);

Route::resource('/sucursales', 'SucursalesController');


Route::resource("/Usuarios", "UsersController")->parameters(["Users"=>"User"]);


Route::post('/Usuarios/actualizarusuario', 'UsersController@actualizarusuario');


Route::resource('/Reportes', 'iTicketController');

Route::post('/Reportes/verDatos', 'iTicketController@verDatos');

Route::get('/Reportes/getVehiculo/{placas}', 'iTicketController@getVehiculo');

Route::get('/Reportes/verTicket/{id}', 'iTicketController@verTicket');

Route::get('/Reportes/verReclamo/{id}', 'iTicketController@verReclamo');

Route::resource('/ReporteVehiculos', 'reporteVehiculosController');

Route::post('/ReporteVehiculos/verDatos', 'reporteVehiculosController@verDatos');

Route::get('/ReporteVehiculos/getLineas/{id}', 'reporteVehiculosController@getLineas');

Route::resource('/estacionamientos', 'EstacionamientoController');

/*Eliminar detalle de estacionamiento*/
Route::post('/estacionamientos/eliminarcajones/{id}', 'EstacionamientoController@eliminarcajones');

//Actualización de cajones
Route::post('/estacionamientos/actualizarcajones', 'EstacionamientoController@actualizarcajones');

//Ruta para el logout 
Route::get('/logout', '\App\Http\Controllers\Auth\LoginController@logout');

Route::post('/sucursales/modificarestatus/{id}', 'SucursalesController@modificarestatus');

Route::post('/estacionamientos/modificarestatus/{id}', 'EstacionamientoController@modificarestatus');

Route::post('/Usuarios/modificarestatus/{id}', 'UsersController@modificarestatus');


//Route::resource("/Usuarios", "UsersController");
//Route::post('Usuarios', 'UsersController')->name('Users.save');
//Route::post('/Clientes', 'ClientesController@store')->name('Clientes.save');

Route::resource('/recompensas', 'RecompensasController');

Route::resource('/beneficios', 'BeneficiosController');
Route::get('/beneficios/list/{nivel}', 'BeneficiosController@list');

Route::get('/promociones/synchronize', 'PromocionesController@synchronize')->name('promociones.synchronize');
Route::resource('/promociones', 'PromocionesController');

Route::resource('/noticias', 'NoticiasController');


Route::resource('/layouteventos', 'LayoutEventosController');

//Route::get('/promociones/synchronize', [App\Http\Controllers\PromocionesController::class, 'synchronize'])->name('promociones.synchronize');
//Route::get('/promociones/synchronize', 'PromocionesController@synchronize')->name('promociones.synchronize');


Auth::routes();
//return redirect()->route('dashboard');

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::resource('/roles', 'RolesController');

Route::post('/roles/actualizarroles', 'RolesController@actualizarroles');

Route::post('/Reportes/actualizarEstatusTicket/{id}', 'iTicketController@actualizarEstatusTicket');


//rutas nuevas
Route::post('guardarmesa','LayoutEventosController@guardarMesa')->name('guardarmesa');
Route::post('guardarlayaut','LayoutEventosController@guardarlayaut')->name('guardar_layaut');
Route::post('actualizarlayaut/{id_evento}','LayoutEventosController@actualizarlayaut')->name('actualizar_layaut');
Route::post('dataeventos', 'LayoutEventosController@datatableeventos')->name('dt_eventos');
Route::get('eliminareventos/{id_evento}','LayoutEventosController@eliminareventos')->name('eliminar_eventos');
Route::get('copiareventos/{id_evento}','LayoutEventosController@copiareventos')->name('copiar_eventos');
Route::get('acomodo/{id_layout}','LayoutEventosController@acomodo')->name('acomodo_evento');
Route::post('guardaracomodo','LayoutEventosController@guardaracomodo')->name('guardar_acomodo');


Route::get('lista_eventos', 'EventosController@index')->name('lista_eventos');
Route::post('datalista_eventos', 'EventosController@datatablelista_eventos')->name('dt_lista_eventos');
Route::get('crear_evento','EventosController@crear_evento')->name('crear_evento');
Route::post('guardar_evento','EventosController@guardar_evento')->name('guardar_evento');
Route::get('editar_eventos/{id_evento}','EventosController@editar_eventos')->name('editar_eventos');
Route::post('actualizar_eventos/{id_evento}','EventosController@actualizar_eventos')->name('actualizar_eventos');
Route::get('eliminar_evento/{id_evento}','EventosController@eliminar_eventos')->name('eliminar_evento');


Route::get('lista_reservacion', 'ReservacionController@index')->name('lista_reservacion');
Route::post('datalista_reservacion', 'ReservacionController@datatablelista_reservacion')->name('dt_lista_reservacion');
Route::get('crear_reservacion','ReservacionController@crear_reservacion')->name('crear_reservacion');
Route::post('mesas_posicion','ReservacionController@mesas_posicion')->name('mesas_posicion');
Route::post('guardar_reservacion','ReservacionController@guardar_reservacion')->name('guardar_reservacion');
Route::get('editar_reservacion/{id_reservacion}','ReservacionController@editar_reservacion')->name('editar_reservacion');
Route::post('actualizar_reservacion/{id_reservacion}','ReservacionController@actualizar_reservacion')->name('actualizar_reservacion');
Route::get('eliminar_reservacion/{id_reservacion}','ReservacionController@eliminar_reservacion')->name('eliminar_reservacion');
Route::get('acceder_compra/{id_reservacion}','ReservacionController@acceder_compra')->name('acceder_compra');
Route::post('compra/{id_reservacion}','ReservacionController@compra')->name('compra');
Route::get('borrar_lugar/{id_lugar}','ReservacionController@borrar_lugar')->name('borrar_lugar');


Route::get('mesas_posiciones/{id_evento}/{id_cliente}','ReservacionController@mesas_posiciones')->name('mesas_posiciones');


Route::get('lista_mesas', 'CatalogoMesasController@index')->name('lista_mesas');
Route::post('datalista_mesas', 'CatalogoMesasController@datatablelista_mesas')->name('dt_lista_mesas');
Route::get('crear_mesa','CatalogoMesasController@crear_mesa')->name('crear_mesa');
Route::post('guardar_mesa','CatalogoMesasController@guardar_mesa')->name('guardar_mesa');
Route::get('editar_mesas/{id_mesa}','CatalogoMesasController@editar_mesas')->name('editar_mesas');
Route::post('actualizar_mesas/{id_mesa}','CatalogoMesasController@actualizar_mesas')->name('actualizar_mesas');
Route::get('eliminar_mesa/{id_mesa}','CatalogoMesasController@eliminar_mesas')->name('eliminar_mesa');

Route::get('eliminar_evento_opcion/{id}/{opcion}/{div}','EventosController@eliminar_evento_opcion')->name('eliminar_evento_opcion');
Route::get('status_evento_opcion/{id}/{opcion}/{div}','EventosController@status_evento_opcion')->name('status_evento_opcion');