@extends('layout')

@section('content')
<script>
    $(document).ready(function() {
        function validarEntradaNumerica(field) {
            const campo = field;
            const valor = campo.value;
            const valorNumerico = parseFloat(valor);

            // Verificar si el valor ingresado es un número válido
            if (!isNaN(valorNumerico)) {
                // Verificar si el valor es mayor que 9999
                if (valorNumerico > 9999) {
                    campo.value = 9999;
                } else {
                    campo.value = valorNumerico;
                }
            } else {
                campo.value = '';
            }
        }

        function validarEntradaNumerica2(field) {
            const campo = field;
            const valor = campo.value;
            const valorNumerico = parseFloat(valor);

            if (!isNaN(valorNumerico)) {
                if (valorNumerico > 100) {
                    campo.value = 100;
                } else {
                    campo.value = valorNumerico;
                }
            } else {
                campo.value = '';
            }
        }

        // Delegación de eventos para inputs dinámicos
        $(document).on('input', 'input[name^="maximobp"], input[name^="efectivoInput"], input[name^="bluepointInput"], input[name^="descuentoEspecialInput"]', function() {
            validarEntradaNumerica(this);
        });

        // Delegación de eventos para inputs dinámicos
        $(document).on('input', 'input[name^="descuentoInput"]', function() {
            validarEntradaNumerica2(this);
        });

        $('#imagen').on('change', function(event) {
            const file = event.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    $('#preview').attr('src', e.target.result);
                }
                reader.readAsDataURL(file);
            }
        });

        $('.imagenlayout').change(function() {
            var imgPath = $(this).find('option:selected').data('imagen');
            var capacidad = $(this).find('option:selected').data('capacidad');
            var zonas = $(this).find('option:selected').data('zonas');
            $('#imageDisplay').attr('src', imgPath);
            $('#capacidad').val(capacidad);
            $(".imagenLayout").css('display','block');
            $(".metodoPagoDiv").css('display','block');

            var $select = $('#layout_zonas');

            // Vaciar el select
            $select.empty();

            // Agregar opción por defecto
            $select.append($('<option>', {
                value: '',
                text: 'Seleccione una opción',
                selected: true,
                disabled: true
            }));

            $.each(zonas, function(index, zona) {
                $select.append($('<option>', {
                    value: zona.id,
                    text: zona.nombre
                }));
            });
        });

        $('#costos').change(function() {
            var tipo = $(this).val();
            $(".selectTipoPagoTabla").css('display','block');
            $(".selectTipoPago").css('display','block');

            if(tipo == 1)
            {
                $('#efectivoInput').val("");
                $(".selectTipoPagoEfectivo").css('display','none');
                $(".selectTipoPagoBP").css('display','block');
            }
            else if(tipo == 2)
            {
                $('#bluepointInput').val("");
                $(".selectTipoPagoEfectivo").css('display','block');
                $(".selectTipoPagoBP").css('display','none');
            }
            else
            {
                $('#efectivoInput').val("");
                $('#bluepointInput').val("");
                $(".selectTipoPagoEfectivo").css('display','block');
                $(".selectTipoPagoBP").css('display','block');
            }
        });

        function updateClasses(isBoletos) {
            $('#class_desc_esp_por_bol_concepto').attr('class', isBoletos ? 'col-sm-5' : 'col-sm-8');
            $('#class_desc_esp_por_bol_bolsincosto')
                .toggle(isBoletos)
                .val('');
            if (!isBoletos) {
                $('#class_desc_esp_por_bol_bolsincosto').attr('class', 'col-sm-4');
            }
        }

        $('#Porcentaje').change(function() {
            updateClasses(false);
        });

        $('#Boletos').change(function() {
            updateClasses(true);
            $('#class_desc_esp_por_bol_valor').val('');
        });

        $(document).on('click', '.eliminar', function(event) {
            var $this = $(this);
            console.log($this.attr("data-id"));
            $("#" + $this.attr("data-id")).remove();
        });

        $('#agregarCostoZona').click(function() {
            var efectivoInput = $('#efectivoInput').val();
            var bluepointInput = $('#bluepointInput').val();
            var layout_zonas = $('#layout_zonas').val();
            var layout_zonas_nombre = $('#layout_zonas').find('option:selected').text();
            var tipoPago = $('#costos').val();

            if (layout_zonas && layout_zonas.length != 0) {
                if (tipoPago == 2 && efectivoInput)
                {
                    if ($('#tipoPago_efectivo_'+layout_zonas).length) {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Advertencia',
                            text: 'Esta zona ya tiene el pago en efectivo'
                        });
                        return;
                    }

                    $('.selectTipoPagoTabla tbody').append(`<tr id="tipoPago_efectivo_${layout_zonas}">
                        <td>
                            ${efectivoInput}
                            <input type="hidden" class="form-control" name="costo[]" value="${efectivoInput}">
                        </td>
                        <td>
                            Efectivo
                            <input type="hidden" class="form-control" name="moneda[]" value="efectivo">
                        </td>
                        <td>
                            ${layout_zonas_nombre}
                            <input type="hidden" class="form-control" name="zona[]" value="${layout_zonas}">
                        </td>
                        <td>
                            <a type="button" class="btn btn-danger btn-sm eliminar" data-id="tipoPago_efectivo_${layout_zonas}">
                                <i class="fa-solid fa-circle-minus"></i>
                            </a>
                        </td>
                    </tr>`);
                }

                if (tipoPago == 1 && bluepointInput) {
                    // Agregar blue point

                    if ($('#tipoPago_bp_'+layout_zonas).length) {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Advertencia',
                            text: 'Esta zona ya tiene el pago en Blue Point'
                        });
                        return;
                    }

                    $('.selectTipoPagoTabla tbody').append(`<tr id="tipoPago_bp_${layout_zonas}">
                        <td>
                            ${bluepointInput}
                            <input type="hidden" class="form-control" name="costo[]" value="${bluepointInput}">
                        </td>
                        <td>
                            Blue Point
                            <input type="hidden" class="form-control" name="moneda[]" value="bp">
                        </td>
                        <td>
                            ${layout_zonas_nombre}
                            <input type="hidden" class="form-control" name="zona[]" value="${layout_zonas}">
                        </td>
                        <td>
                            <button type="button" class="btn btn-danger btn-sm eliminar" data-id="tipoPago_bp_${layout_zonas}">
                                <i class="fa-solid fa-circle-minus"></i>
                            </button>
                        </td>
                    </tr>`);
                }

                if (tipoPago == 3 && efectivoInput && bluepointInput) {
                    // Agregar mixto

                    if ($('#tipoPago_mixto_'+layout_zonas).length) {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Advertencia',
                            text: 'Esta zona ya tiene el pago mixto (efectivo y Blue Point).'
                        });
                        return;
                    }

                    $('.selectTipoPagoTabla tbody').append(`<tr id="tipoPago_mixto_${layout_zonas}">
                        <td>
                            ${efectivoInput} (efectivo) / ${bluepointInput} (blue point)
                            <input type="hidden" class="form-control" name="costo[]" value="${efectivoInput}/${bluepointInput}">
                        </td>
                        <td>
                            Mixto
                            <input type="hidden" class="form-control" name="moneda[]" value="mixto">
                        </td>
                        <td>
                            ${layout_zonas_nombre}
                            <input type="hidden" class="form-control" name="zona[]" value="${layout_zonas}">
                        </td>
                        <td>
                            <a type="button" class="btn btn-danger btn-sm eliminar" data-id="tipoPago_mixto_${layout_zonas}">
                                <i class="fa-solid fa-circle-minus"></i>
                            </a>
                        </td>
                    </tr>`);
                }
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Advertencia',
                    text: 'Por favor, seleccione una zona antes de agregar.'
                });
            }
            /* $('#efectivoInput').val("");
            $('#bluepointInput').val(""); */
        });

        $('#agregarDescuento').click(function() {
            var descuentoInput = parseFloat($('#descuentoInput').val()); // Convertir a número
            var nivelDescuento = $('#nivelDescuento').val();
            var nivelDescuento_nombre = $('#nivelDescuento').find('option:selected').text();

            if (nivelDescuento && nivelDescuento.length !== 0) {
                // Obtener valores actuales de los inputs
                var descuentosExistentes = $('input[name="descuentopornivel[]"]').map(function() {
                    return parseFloat($(this).val());
                }).get();
                var nivelesExistentes = $('input[name="niveltipo[]"]').map(function() {
                    return $(this).val();
                }).get();

                var duplicado = false;

                if (!isNaN(descuentoInput) && descuentoInput !== 0) { // Verificar que no es NaN y no es 0
                    // Verificar duplicados para la combinación de descuento y nivel
                    for (var i = 0; i < descuentosExistentes.length; i++) {
                        if (descuentosExistentes[i] === descuentoInput && nivelesExistentes[i] === nivelDescuento) {
                            duplicado = true;
                            break;
                        }
                    }

                    if (!duplicado) {
                        $('.descuentoTabla tbody').append(`<tr id="desc_nivel_${nivelDescuento}">
                            <td>
                                ${descuentoInput} %
                                <input type="hidden" class="form-control" name="descuentopornivel[]" value="${descuentoInput}">
                            </td>
                            <td>
                                ${nivelDescuento_nombre}
                                <input type="hidden" class="form-control" name="niveltipo[]" value="${nivelDescuento}">
                            </td>
                            <td>
                                <a type="button" class="btn btn-danger btn-sm eliminar" data-id="desc_nivel_${nivelDescuento}">
                                    <i class="fa-solid fa-circle-minus"></i>
                                </a>
                            </td>
                        </tr>`);
                        $('#descuentoInput').val("");
                    } else {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Advertencia',
                            text: 'No se puede repetir el mismo descuento con el mismo nivel.'
                        });
                    }
                }
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Advertencia',
                    text: 'Por favor, seleccione un nivel antes de agregar.'
                });
            }
        });

        function generateUUID() {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                var r = Math.random() * 16 | 0, v = c === 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        }

        $('#agregarDescuentoEspecial').click(function() {
            var descuentoEspecialInput = parseFloat($('#descuentoEspecialInput').val());
            var descuentoConceptoEspecial = $('#descuentoConceptoEspecial').val();
            var descuentoEspecialBSCInput = $('#descuentoEspecialBSCInput').val();
            var selectedValue = $('input[name="tipoDescEspRadio"]:checked').val();

            var uuid = generateUUID();

            if (!isNaN(descuentoEspecialInput) && descuentoEspecialInput !== 0) {
                if (descuentoConceptoEspecial.length !== 0) {
                    let columna = `<tr id="desc_especial_${uuid}">`;
                    let datoDescuento = "";

                    if (selectedValue == 1) {
                        columna += `<td>
                                        Porcentaje
                                        <input type="hidden" class="form-control" name="descuentoespecialTipo[]" value="1">
                                    </td>`;
                        datoDescuento = `${descuentoEspecialInput.toFixed(2)} %`;
                    } else {
                        columna += `<td>
                                        Boletos
                                        <input type="hidden" class="form-control" name="descuentoespecialTipo[]" value="2">
                                    </td>`;
                        datoDescuento = `${descuentoEspecialInput} x ${descuentoEspecialBSCInput}`;
                    }

                    columna += `<td>
                                    ${datoDescuento}
                                    <input type="hidden" class="form-control" name="descuentoespecial1[]" value="${descuentoEspecialInput}">
                                    <input type="hidden" class="form-control" name="descuentoespecial2[]" value="${descuentoEspecialBSCInput}">
                                </td>
                                <td>
                                    ${descuentoConceptoEspecial}
                                    <input type="hidden" class="form-control" name="conceptodescuentoespecial[]" value="${descuentoConceptoEspecial}">
                                </td>
                                <td>Activado</td>
                                <td>
                                    <a type="button" class="btn btn-danger btn-sm eliminar" data-id="desc_especial_${uuid}">
                                        <i class="fa-solid fa-circle-minus"></i>
                                    </a>
                                </td>
                            </tr>`;

                    $('.descuentoEspecialTabla tbody').append(columna);
                    $('#descuentoEspecialInput').val("");
                    $('#descuentoConceptoEspecial').val("");
                    $('#descuentoEspecialBSCInput').val("");
                } else {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Advertencia',
                        text: 'No se puede agregar un descuento especial sin concepto.'
                    });
                }
            } else {
                Swal.fire({
                    icon: 'warning',
                    title: 'Advertencia',
                    text: 'No se puede agregar un descuento especial sin valor.'
                });
            }
        });
    });
</script>
<style>
    div.addRow {
        line-height: 45px;
        background-color: #fff;
        padding-left: 10px;
        border-bottom: 1px solid;
        border-top: 1px solid #e5e5e5;
    }

    .dataTables_filter {
        display: none;
    }
</style>
<script>
    $('body').on('submit','.form_guardar', function(e){
        e.preventDefault();

        formData = new FormData(document.getElementById($(this).attr('id')));
        var url = $(`#${$(this).attr('id')}`).attr('action');

        $.ajax({
            type:'POST',
            url:url,
            contentType: false,
            processData: false,
            datatype: "JSON",
            data: formData,
            beforeSend: function(){
                $("#btn_guardar").val("Enviando..");
                $("#btn_guardar").attr("disabled","disabled");
            }
        }).done(function (response) {
            Swal.fire({
                icon: response.icon,
                title: response.title,
                html: response.text,
            });

            $(location).attr('href',response.ruta);

            console.log(response);
        }).fail(function (response) {
            console.log("fallo");
            console.log(response);

            $(".error").remove();

            $.each(response.responseJSON.errors, function (index, value) {
                $("#" + index).after('<span class="error form-text text-danger"><b>'+value+'</b></span>');
            });
        });

        $("#btn_guardar").val("Guardar");
        $("#btn_guardar").attr("disabled",false);
    })

    //Eliminar datos de tabla
    $('body').on('click', '.btn_tabla', function(){
        var $this = $(this);

        Swal.fire({
            html: $this.attr("data-text"),
            icon: "warning",
            showCancelButton: !0,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Si",
            confirmButtonClass: "btn btn-primary",
            cancelButtonClass: "btn btn-danger ml-1",
            buttonsStyling: !1,
        }).then(function (t) {
            t.value
                ? $.ajax({
                    url: $this.attr("data-route"),
                    type: 'get',
                }).done(function (response) {

                    Swal.fire({
                        icon: response.icon,
                        title: response.title,
                        text: response.text
                    })

                    if(response.estatus)
                    {
                        $this.attr('class', '').addClass('btn '+response.boton);
                        $this.html("<i class='fa-solid fa-check'></i> "+response.texto);
                        $this.attr('data-text', response.texto2);
                    }
                    else
                    {
                        $("#"+response.id_div).remove();
                    }

                    console.log(response);
                }).fail(function (response) {
                    console.log("fallo");
                    console.log(response);  
                    
                    toastr.error("Error al enviar los datos", "Error", {
                        closeButton: !0,
                        tapToDismiss: !1,
                        progressBar: !0,
                    })
                })
            : t.dismiss === Swal.DismissReason.cancel;
        });
    })
</script>
<link data-require="datatables@*" data-semver="1.10.12" rel="stylesheet" href="//cdn.datatables.net/1.10.12/css/jquery.dataTables.min.css" />
<link rel="stylesheet" href="//cdn.datatables.net/rowreorder/1.2.0/css/rowReorder.dataTables.min.css" />
    <div class="card card-custom">
        <div class="card-header card-header-tabs-line nav-tabs-line-3x">
            <div class="card-toolbar">
                <ul class="nav nav-tabs nav-bold nav-tabs-line nav-tabs-line-3x">
                    <li class="nav-item mr-3">
                        <a class="nav-link active" data-toggle="tab" href="#kt_user_edit_tab_1">
                            <span class="nav-icon">
                                <span class="svg-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <polygon points="0 0 24 0 24 24 0 24" />
                                            <path d="M12.9336061,16.072447 L19.36,10.9564761 L19.5181585,10.8312381 C20.1676248,10.3169571 20.2772143,9.3735535 19.7629333,8.72408713 C19.6917232,8.63415859 19.6104327,8.55269514 19.5206557,8.48129411 L12.9336854,3.24257445 C12.3871201,2.80788259 11.6128799,2.80788259 11.0663146,3.24257445 L4.47482784,8.48488609 C3.82645598,9.00054628 3.71887192,9.94418071 4.23453211,10.5925526 C4.30500305,10.6811601 4.38527899,10.7615046 4.47382636,10.8320511 L4.63,10.9564761 L11.0659024,16.0730648 C11.6126744,16.5077525 12.3871218,16.5074963 12.9336061,16.072447 Z" fill="#000000" fill-rule="nonzero" />
                                            <path d="M11.0563554,18.6706981 L5.33593024,14.122919 C4.94553994,13.8125559 4.37746707,13.8774308 4.06710397,14.2678211 C4.06471678,14.2708238 4.06234874,14.2738418 4.06,14.2768747 L4.06,14.2768747 C3.75257288,14.6738539 3.82516916,15.244888 4.22214834,15.5523151 C4.22358765,15.5534297 4.2250303,15.55454 4.22647627,15.555646 L11.0872776,20.8031356 C11.6250734,21.2144692 12.371757,21.2145375 12.909628,20.8033023 L19.7677785,15.559828 C20.1693192,15.2528257 20.2459576,14.6784381 19.9389553,14.2768974 C19.9376429,14.2751809 19.9363245,14.2734691 19.935,14.2717619 L19.935,14.2717619 C19.6266937,13.8743807 19.0546209,13.8021712 18.6572397,14.1104775 C18.654352,14.112718 18.6514778,14.1149757 18.6486172,14.1172508 L12.9235044,18.6705218 C12.377022,19.1051477 11.6029199,19.1052208 11.0563554,18.6706981 Z" fill="#000000" opacity="0.3" />
                                        </g>
                                    </svg>
                                </span>
                            </span>
                            <span class="nav-text font-size-lg">Datos Eventos</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>

        <div class="card-body">
            <div class="tab-content">
                <div class="tab-pane show active px-7" id="kt_user_edit_tab_1" role="tabpanel">
                    <form method="POST" action="{{ $editar ? route('actualizar_eventos', $evento['id']) : route('guardar_evento') }}" class="form_guardar" id="form_guardar_evento" enctype="multipart/form-data">
                        @csrf
                        <div class="row text-center">
                            <div class="col-xl-1"></div>
                            <div class="col-xl-10 my-2 mb-4">
                                <div class="row">
                                    <label class="col-3"></label>
                                    <div class="col-9"></div>
                                </div>
    
                                <div class="form-group row">
                                    <label class="col-form-label col-3 text-lg-right text-left">Nombre</label>
                                    <div class="col-9">
                                        <input name="nombreevento" id="nombreevento" class="form-control form-control-lg form-control-solid" type="text" value="{{ $evento['nombre'] ?? "" }}" />
                                    </div>
                                </div>
                                
                                <div class="form-group row">
                                    <label class="col-form-label col-3 text-lg-right text-left">Fecha</label>
                                    <div class="col-4">
                                        <input name="fechaevento" id="fechaevento" class="form-control form-control-lg form-control-solid" type="date" value="{{ $evento['fecha'] ?? "" }}" />
                                    </div>
                                
                                    <label class="col-form-label col-2 text-lg-right text-left">Horario</label>
                                    <div class="col-3">
                                        <input name="horaevento" id="horaevento" class="form-control form-control-lg form-control-solid" type="time" value="{{ $evento['hora'] ?? "" }}" />
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-3 form-label col text-lg-right text-left">Sucursal</label>
                                    <div class="col-9">
                                        <div class="input-group input-group-lg input-group-solid" id="idSucursal">
                                            <select name="idSucursal" class="form-control form-control-lg form-control-solid">
                                                <option selected disabled>Seleccione una opción</option>
                                                @foreach($sucursales as $sucursal)
                                                    <option value="{{$sucursal->id}}" {{ $editar ? ($evento['id_sucursal'] == $sucursal->id ? "selected" : "") : "" }}>
                                                        {{$sucursal->nombre}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-form-label col-3 text-lg-right text-left">Espacio</label>
                                    <div class="col-9">
                                        <input name="espacio" id="espacio" class="form-control form-control-lg form-control-solid" type="text" value="{{ $evento['espacio'] ?? "" }}" />
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-form-label col-3 text-lg-right text-left">Layout evento</label>
                                    <div class="col-4">
                                        <div class="input-group input-group-lg input-group-solid" id="idlayout">
                                            <select name="idlayout" class="form-control form-control-lg form-control-solid imagenlayout">
                                                <option selected disabled>Seleccione una opción</option>
                                                @foreach($layout as $item)
                                                    @php
                                                        $filteredZonas = $zonas->where('idlayout_evento', $item->id);
                                                    @endphp
                                                    <option value="{{$item->id}}" data-capacidad="{{ $item->capacidad }}" data-imagen="{{ asset($item->sillas) }}" {{ $editar ? ($evento['id_layout'] == $item->id ? "selected" : "") : "" }} data-zonas="{{ $filteredZonas->toJson() }}">
                                                        {{$item->nombre}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <label class="col-form-label col-2 text-lg-right text-left">Capacidad</label>
                                    <div class="col-3">
                                        <input name="capacidad" id="capacidad" class="form-control form-control-lg form-control-solid" type="text" value="{{ $evento['capacidad'] ?? "" }}" readonly />
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-form-label col-3 text-lg-right text-left">Boletos BP</label>
                                    <div class="col-4">
                                        <input name="maximobp" id="maximobp" class="form-control form-control-lg form-control-solid" type="text" value="{{ $evento['max_boletos_bp'] ?? "" }}"  oninput="validarEntradaNumerica(this)" />
                                    </div>
                                </div>

                                @php
                                    $displayStyle = ($editar && count($eventocosto) != 0) ? '' : 'style="display: none;"';
                                @endphp

                                <hr class="mt-5 mb-5 metodoPagoDiv" <?= $displayStyle; ?>>

                                <div class="form-group row metodoPagoDiv" <?= $displayStyle; ?>>
                                    <h4>Metodo de pago</h4>
                                </div>

                                <div class="form-group row">
                                    <div class="col-sm-4 metodoPagoDiv" <?= $displayStyle; ?>>
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                                <label class="input-group-text" for="costos">Costo</label>
                                            </div>
                                            <select name="tipo_pago" class="custom-select" id="costos">
                                                <option selected disabled>Seleccione una opción</option>
                                                <option value="1">Blue points</option>
                                                <option value="2">Efectivo</option>
                                                <option value="3">Mixto</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="col-sm-12 selectTipoPagoEfectivo" <?= $displayStyle; ?>>
                                            <div class="input-group mb-3">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">Efectivo</span>
                                                </div>
                                                <input type="text" class="form-control" name="efectivoInput" id="efectivoInput">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 selectTipoPagoBP" <?= $displayStyle; ?>>
                                            <div class="input-group mb-3">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">Blue Point</span>
                                                </div>
                                                <input type="text" class="form-control" name="bluepointInput" id="bluepointInput">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4 selectTipoPago" <?= $displayStyle; ?>>
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                                <label class="input-group-text" for="layout_zonas">Zona</label>
                                            </div>
                                            <select class="custom-select" name="layout_zonas" id="layout_zonas">
                                                <option selected disabled>Seleccione una opción</option>
                                                @if ($editar)
                                                    @foreach ($zonasselect as $item)
                                                        <option value="{{ $item->id }}">{{ $item->nombre }}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            <div class="input-group-append">
                                              <button class="btn btn-success" id="agregarCostoZona" type="button">Agregar</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 selectTipoPagoTabla mt-2" <?= $displayStyle; ?>>
                                        <table class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th scope="col">Costo</th>
                                                    <th scope="col">Moneda</th>
                                                    <th scope="col">Zona</th>
                                                    <th scope="col">Opciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if ($editar)
                                                    @if (count($eventocosto) != 0)
                                                        @foreach ($eventocosto as $item)

                                                        @if ($item->tipo == 1)
                                                            @php
                                                                $divValue = "tipoPago_efectivo_".$item->id_evento_seccion;
                                                            @endphp
                                                        @elseif ($item->tipo == 2)
                                                            @php
                                                                $divValue = "tipoPago_bp_".$item->id_evento_seccion;
                                                            @endphp
                                                        @elseif ($item->tipo == 3)
                                                            @php
                                                                $divValue = "tipoPago_mixto_".$item->id_evento_seccion;
                                                            @endphp
                                                        @endif

                                                        <tr id="{{ $divValue }}">
                                                            <td>
                                                                @if ($item->tipo == 1)
                                                                    {{ $item->dinero }}
                                                                    <input type="hidden" class="form-control" name="costo[]" value="{{ $item->dinero }}">
                                                                @elseif ($item->tipo == 2)
                                                                    {{ $item->blue_points }}
                                                                    <input type="hidden" class="form-control" name="costo[]" value="{{ $item->blue_points }}">
                                                                @elseif ($item->tipo == 3)
                                                                    {{ $item->dinero }} (efectivo) / {{ $item->id_evento_seccion }} (blue point)
                                                                    <input type="hidden" class="form-control" name="costo[]" value="{{ $item->dinero }}/{{ $item->blue_points }}">
                                                                @endif
                                                            </td>
                                                            <td>
                                                                @if ($item->tipo == 1)
                                                                    Efectivo
                                                                    <input type="hidden" class="form-control" name="moneda[]" value="efectivo">
                                                                @elseif ($item->tipo == 2)
                                                                    Blue Points
                                                                    <input type="hidden" class="form-control" name="moneda[]" value="bp">
                                                                @elseif ($item->tipo == 3)
                                                                    Mixto
                                                                    <input type="hidden" class="form-control" name="moneda[]" value="mixto">
                                                                @endif
                                                            </td>
                                                            <td>
                                                                {{ $item->nombre }}
                                                                <input type="hidden" class="form-control" name="zona[]" value="{{ $item->id_evento_seccion }}">
                                                            </td>
                                                            <td>
                                                                @php
                                                                    $textoStatus = ($item->status) ? "¿Desactivar este metodo de pago?" : "¿Activar este metodo de pago?";
                                                                    $color = ($item->status) ? "success" : "warning";
                                                                    $texto = ($item->status) ? "Activado" : "Desactivado";
                                                                @endphp
                                                                {{-- <a type="button" class="btn btn-{{ $color }} btn-sm btn_tabla" data-text="{{ $textoStatus }}" data-route="{{ route('status_evento_opcion', [
                                                                    'id' => $item->id, 
                                                                    'opcion' => 1,
                                                                    'div' => $divValue,
                                                                ]) }}">
                                                                    <i class="fa-solid fa-check"></i> {{ $texto }}
                                                                </a> --}}
                                                                <button type="button" class="btn btn-danger btn-sm btn_tabla" data-text="¿Eliminar este metodo de pago?" data-route="{{ route('eliminar_evento_opcion', [
                                                                    'id' => $item->id, 
                                                                    'opcion' => 1,
                                                                    'div' => $divValue,
                                                                ]) }}">
                                                                    <i class="fa-solid fa-circle-minus"></i>
                                                                </button>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    @endif
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <hr class="mt-5 mb-5">

                                <div class="form-group row">
                                    <h4>Descuentos por nivel</h4>
                                </div>

                                <div class="form-group row">
                                    <div class="col-sm-6">
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">Descuento</span>
                                            </div>
                                            <input type="text" class="form-control" name="descuentoInput" id="descuentoInput"  oninput="validarEntradaNumerica(this)">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                                <label class="input-group-text" for="nivelDescuento">
                                                    Nivel
                                                </label>
                                            </div>
                                            <select class="custom-select" name="nivelDescuento" id="nivelDescuento">
                                                <option selected disabled>Seleccione una opción</option>
                                                @foreach ($nivel as $item)
                                                    <option value="{{ $item->id }}">
                                                        {{ $item->descripcion }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            <div class="input-group-append">
                                              <button class="btn btn-success" id="agregarDescuento" type="button">Agregar descuento</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 mt-2 descuentoTabla">
                                        <table class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th scope="col">Descuento</th>
                                                    <th scope="col">Nivel</th>
                                                    <th scope="col">Opciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if ($editar)
                                                    @if (count($eventodescuentonivel) != 0)
                                                        @foreach ($eventodescuentonivel as $item)
                                                            <tr id="desc_nivel_{{ $item->evento_descuento_nivel_id }}">
                                                                <td>
                                                                    {{ $item->descuento }}
                                                                    <input type="hidden" class="form-control" name="descuentopornivel[]" value="{{ $item->descuento }}">
                                                                </td>
                                                                <td>
                                                                    {{ $item->nombre }}
                                                                    <input type="hidden" class="form-control" name="niveltipo[]" value="{{ $item->id_beneficio_nivel }}">
                                                                </td>
                                                                <td>
                                                                    @php
                                                                        $textoStatus = $item->status ? "¿Desactivar este descuento del nivel {$item->nombre}?" : "¿Activar este descuento del nivel {$item->nombre}?";
                                                                        $color = $item->status ? "success" : "warning";
                                                                        $texto = $item->status ? "Activado" : "Desactivado";
                                                                    @endphp

                                                                    <a type="button" class="btn btn-{{ $color }} btn-sm btn_tabla" 
                                                                    data-text="{{ $textoStatus }}" 
                                                                    data-route="{{ route('status_evento_opcion', [
                                                                        'id' => $item->evento_descuento_nivel_id, 
                                                                        'opcion' => 2,
                                                                        'div' => 'desc_nivel_'.$item->evento_descuento_nivel_id,
                                                                    ]) }}">
                                                                        <i class="fa-solid fa-check"></i> {{ $texto }}
                                                                    </a>
                                                                    <a type="button" class="btn btn-danger btn-sm btn_tabla" data-text="¿Eliminar este descuento del nivel {{ $item->nombre }}?" data-route="{{ route('eliminar_evento_opcion', [
                                                                        'id' => $item->evento_descuento_nivel_id,
                                                                        'opcion' => 2,
                                                                        'div' => 'desc_nivel_'.$item->evento_descuento_nivel_id,
                                                                    ]) }}">
                                                                        <i class="fa-solid fa-circle-minus"></i>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    @endif
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <hr class="mt-5 mb-5">

                                <div class="form-group row">
                                    <h4>Descuentos especiales</h4>
                                </div>

                                <div class="form-group row">
                                    <div class="col-sm-12 mt-2 mb-2">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="tipoDescEspRadio" id="Porcentaje" value="1" checked>
                                            <label class="form-check-label" for="Porcentaje">
                                                Porcentaje
                                            </label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="tipoDescEspRadio" id="Boletos" value="2">
                                            <label class="form-check-label" for="Boletos">
                                                Boletos
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-sm-3" id="class_desc_esp_por_bol_valor">
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">Valor</span>
                                            </div>
                                            <input type="text" class="form-control" name="descuentoEspecialInput" id="descuentoEspecialInput">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">%</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4" id="class_desc_esp_por_bol_bolsincosto" style="display: none;">
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">Boletos<br>sin costo</span>
                                            </div>
                                            <input type="text" class="form-control" name="descuentoEspecialBSCInput" id="descuentoEspecialBSCInput">
                                        </div>
                                    </div>
                                    <div class="col-sm-8" id="class_desc_esp_por_bol_concepto">
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                                <label class="input-group-text" for="descuentoConceptoEspecial">
                                                    Concepto
                                                </label>
                                            </div>
                                            <input type="text" class="form-control" name="descuentoConceptoEspecial" id="descuentoConceptoEspecial">
                                            <div class="input-group-append">
                                              <button class="btn btn-success" id="agregarDescuentoEspecial" type="button">Agregar<br>descuento</button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 mt-2 descuentoEspecialTabla">
                                        <table class="table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th scope="col">Tipo</th>
                                                    <th scope="col">Descuento</th>
                                                    <th scope="col">Concepto</th>
                                                    <th scope="col">Estado</th>
                                                    <th scope="col">Opciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if ($editar)
                                                    @if ($eventodescuentoespecial->count() != 0)
                                                        @foreach ($eventodescuentoespecial as $item)
                                                            <tr id="desc_especial_{{ $item->id }}">
                                                                <td>
                                                                    {{ $item->tipo == 1 ? "Porcentaje" : "Boletos" }}
                                                                    <input type="hidden" class="form-control" name="descuentoespecialTipo[]" value="{{ $item->tipo }}">
                                                                </td>
                                                                <td>
                                                                    @if ($item->tipo == 1)
                                                                        {{ $item->valor }} %
                                                                    @else
                                                                        {{ $item->valor }} x {{ $item->boletos_gratis }}
                                                                    @endif
                                                                    <input type="hidden" class="form-control" name="descuentoespecial1[]" value="{{ $item->valor }}">
                                                                    <input type="hidden" class="form-control" name="descuentoespecial2[]" value="{{ $item->boletos_gratis }}">
                                                                </td>
                                                                <td>
                                                                    {{ $item->concepto }}
                                                                    <input type="hidden" class="form-control" name="conceptodescuentoespecial[]" value="{{ $item->concepto }}">
                                                                </td>
                                                                <td>
                                                                    @php
                                                                        $textoStatus = $item->status ? "¿Desactivar este descuento especial llamado {$item->concepto}?" : "¿Activar este descuento especial llamado {$item->concepto}?";
                                                                        $color = $item->status ? "success" : "warning";
                                                                        $texto = $item->status ? "Activado" : "Desactivado";
                                                                    @endphp
                                                                    <a type="button" class="btn btn-{{ $color }} btn-sm btn_tabla" 
                                                                    data-text="{{ $textoStatus }}" 
                                                                    data-route="{{ route('status_evento_opcion', [
                                                                            'id' => $item->id, 
                                                                            'opcion' => 3, 
                                                                            'div' => 'desc_especial_' . $item->id,
                                                                        ]) }}"
                                                                    >
                                                                        <i class="fa-solid fa-check"></i> {{ $texto }}
                                                                    </a>
                                                                    <a type="button" class="btn btn-danger btn-sm btn_tabla" 
                                                                    data-text="¿Eliminar este descuento especial llamado {{ $item->concepto }}?" 
                                                                    data-route="{{ route('eliminar_evento_opcion', [
                                                                            'id' => $item->id, 
                                                                            'opcion' => 3,
                                                                            'div' => 'desc_especial_' . $item->id,
                                                                        ]) }}">
                                                                        <i class="fa-solid fa-circle-minus"></i>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    @endif
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                
                                <hr class="mt-5 mb-5">

                                <div class="form-group row mt-5">
                                    <label class="col-form-label col-3 text-lg-right text-left">Imagen</label>
                                    <div class="col-9">
                                        <input name="imagen" id="imagen" class="form-control form-control-lg form-control-solid" type="file" accept="image/png, image/jpeg"/>
                                    </div>
                                    <br>
                                    <div class="col-9 mt-4 text-center">
                                        <label class="col-form-label col-3 text-lg-right text-left">
                                            Imagen del evento
                                        </label>
                                        <img id="preview" src="{{ $evento['imagen'] ?? "" }}" alt="Imagen del evento" class="img-fluid" width="350px" />
                                    </div>
                                </div>

                                <div class="form-group row mt-5 imagenLayout" <?= $displayStyle; ?>>
                                    <div class="col-12">
                                        <label class="col-form-label col-3 text-lg-right text-left">Imagen del layout</label>
                                        <img id="imageDisplay" class="img-fluid" src="{{ $evento['sillas'] ?? "" }}" alt="Imagen del layout" width="350px" />
                                    </div>
                                </div>
                            </div>
    
                            <div class="col-xl-12 my-2 mt-5">
                                <div class="form-group row mb-3">
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-success" id="btn_guardar">{{ $editar ? "Actualizar" : "Guardar" }}</button>
                                        <a href="{{route('lista_eventos')}}" class="btn btn-danger font-weight-bolder">Cancelar</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
