<!DOCTYPE html>
<html lang="es">
<head>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="static-csrf-token">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Eventos y Mesas</title>
    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="shortcut icon" href="static-path/foliatti.ico" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.3.2/html2canvas.min.js"></script>
    <style>
        .cuadro {
            background-color: #f0f0f0;
            border: 1px solid #aaa;
            cursor: pointer;
            width: 100%;
            aspect-ratio: 1 / 1;
            position: relative;
        }
        .cuadro::before {
            content: attr(data-posicion);
            position: absolute;
            top: 5px;
            left: 5px;
            font-size: 12px;
            color: rgba(0, 0, 0, 0.3);
        }
        .mesa {
            position: relative;
            border: 1px solid #000;
            width: 47px;
            height: 47px;
            text-align: center;
            margin: 1px;
            font-size: 10px;
            background-color: #fff;
        }
        .close-button {
            position: absolute;
            top: 0;
            right: 0;
            width: 10px;
            height: 10px;
            padding: 0;
            border-radius: 50%;
            cursor: pointer;
            background-image: url({{ asset('images/x.jpg') }});
            background-size: 14px 14px; /* Ajusta el tamaño de la imagen */
            background-repeat: no-repeat;
            background-position: center;
            text-indent: -9999px; /* Esconde el texto */
        }
        @media (max-width: 768px) {
            .close-button {
                display: none;
            }
            .mesa {
                cursor: pointer;
                /* Desactivar arrastre en pantallas pequeñas */
                pointer-events: auto;
            }
        }
        header {
            position: fixed;
            top: 0;
            width: 100%;
            background-color: #fff;
            z-index: 1000;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
        }
        .logo {
            max-height: 40px;
        }
        .header-right {
            display: flex;
            align-items: center;
        }
        .header-right p {
            margin: 0;
            margin-right: 20px;
        }
        .fixed-size {
            width: 50px; /* Ajusta el tamaño según tus necesidades */
            height: 50px; /* Ajusta el tamaño según tus necesidades */
            object-fit: cover; /* Para asegurarse de que la imagen se ajuste dentro de las dimensiones */
        }
    </style>
</head>
<body class="d-flex flex-column min-vh-100">
    <div id="loading-screen" class="d-none fixed-top d-flex justify-content-center align-items-center" style="width:100%; height:100%; background-color:rgba(0,0,0,0.5); z-index:9999;">
        <div class="text-center">
            <div class="spinner-border text-light" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
            <p class="text-light mt-2">Procesando...</p>
        </div>
    </div>    
    
    <header style="background-color: #470a68;">
        <div class="container-fluid">
            <div class="header-content">
                <img src="{{ asset('css/media/logos/FoliattiApp_logo.png') }}" alt="Logo" class="logo">
                <div class="header-right">
                    <p style="color: white;">Hola, <b>{{ auth()->user()->nombre }}</b></p>

                    @if ($mesasposicionadas->count() == 0)
                        <a href="{{route('layouteventos.index')}}" class="btn btn-primary btn_regresar">Regresar</a>
                    @endif
                </div>
            </div>
        </div>
    </header>
    <div class="container-fluid flex-grow-1 d-flex flex-column" style="padding-top: 80px;">
        <div class="row flex-grow-1">
            <div class="col-12 col-lg-8 d-flex flex-column">
                <div class="row form-group" style="background-color: #470a68;margin-left: 0px;margin-right: 0px;">
                    <div class="col-12 d-flex justify-content-center">
                        <h3 class="text-white">ESCENARIO</h3>
                    </div>
                </div>

                <form method="POST" action="{{ route('guardar_acomodo') }}" class="form_guardar flex-grow-1 d-flex flex-column" id="form_guardar_acomodo" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="evento_id" id="evento_id" value="{{ $layoutEvento->id }}">
                    <input type="hidden" name="publicado" id="publicado" value="0">
                    <div class="cuadricula flex-grow-1 d-grid" id="cuadricula"></div>
                    <div class="row form-group mt-3">
                        <div class="col-12 d-flex justify-content-end">
                            <button type="submit" class="btn btn-success" style="margin-right: 3px" id="btn_guardar">Guardar</button> 
                            <button type="submit" class="btn btn-success" style="margin-right: 3px" id="btn_guardar_publicado">Publicar</button> 
                            <a href="{{route('layouteventos.index')}}" class="btn btn-danger">
                                Cancelar {{ ($mesasposicionadas->count() == 0) ? "" : "y regresar" }}
                            </a>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-12 col-lg-4">
                <div class="col-sm-12">
                    <div id="lista_error"></div>
    
                    <div class="mesas-container p-2 border overflow-auto">
                        <p>Evento: <b>{{ $layoutEvento->nombre }}</b>
                        <br>Sucursal: <b>{{ $sucursal['nombre'] }}</b>
                        <br>Espacio: <b>{{ $layoutEvento->espacio }}</b>
                        <br>Estatus: <b>{{ $layoutEvento->status ? "Activo" : "Desactivdo" }}</b></p>
                        <div class="container">
                            <div class="row" id="divCuadrados"></div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 mt-3 p-2 overflow-auto">
                    <table class="table">
                        @foreach ($cantidad_mesa as $item)
                            <tr>
                                <td class="align-middle">
                                    <img src="{{ asset($item->icono) }}" class="img-fluid fixed-size">
                                </td>
                                <td class="align-middle text-start">
                                    {{ $item->nombre }} ({{ $item->cantidad }})
                                </td>
                            </tr>
                        @endforeach
                    </table>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <script>
        @foreach ($Layout_evento_mesa as $key => $item)
            @if ($loop->first)
                let mesas = [
            @endif

            @for ($i = 0; $i < $item->cantidad; $i++)
                {
                    id_mesa: '{{ $item->id }}',
                    nombre: '{{ $item->nombre }}',
                    sillas: '{{ $item->sillas }}',
                    icono: '{{ asset($item->icono) }}',
                    eventoid: '{{ $item->idlayout_evento }}',
                },
            @endfor

            @if ($loop->last)
                ];
            @endif
        @endforeach

        @foreach ($Layout_evento_seccion as $item)
            @if ($loop->first)
                const secciones = [    
            @endif
                {
                    id: '{{ $item->id }}',
                    nombre: '{{ $item->nombre }}',
                    codigo: '{{ $item->codigo }}',
                    color: '{{ $item->color }}',
                },
            @if ($loop->last)              
                ];
            @endif
        @endforeach
        
        @foreach ($mesasposicionadas as $item)
            @if ($loop->first)
                const mesasposicionadas = [    
            @endif
                {
                    id_mesa: '{{ $item->id_mesa }}',
                    posicion: '{{ $item->posicion }}',
                    nom_mesa: '{{ $item->nom_mesa }}',
                    sillas: '{{ $item->sillas }}',
                    id_secion: '{{ $item->id_seccion }}',
                    nom_secion: '{{ $item->nom_secion }}',
                    codigo: '{{ $item->codigo }}',
                    color: '{{ $item->color }}',
                    icono: '{{ asset($item->icono) }}',
                    idlayout_evento: '{{ $item->idlayout_evento }}',
                },
            @if ($loop->last)              
                ];
            @endif
        @endforeach  

        function generarCuadricula(filas, columnas) {
            const cuadricula = document.getElementById('cuadricula');
            cuadricula.style.gridTemplateColumns = `repeat(${columnas}, 1fr)`;
            cuadricula.style.gridTemplateRows = `repeat(${filas}, 1fr)`;
            cuadricula.style.gap = '5px';

            for (let i = 0; i < filas * columnas; i++) {
                const cuadro = document.createElement('div');
                cuadro.classList.add('cuadro');
                cuadro.dataset.posicion = i + 1; // Adjusted to start from 1
                cuadro.addEventListener('dragover', permitirSoltar);
                cuadro.addEventListener('drop', soltarMesa);
                cuadricula.appendChild(cuadro);
            }
        }

        function permitirSoltar(event) {
            event.preventDefault();
        }

        function soltarMesa(event) {
            event.preventDefault();
            const data = event.dataTransfer.getData('text/plain');
            const mesa = document.getElementById(data);
            const cuadro = event.target;

            if (cuadro.classList.contains('cuadro')) {
                cuadro.appendChild(mesa);
                mesa.style.width = '100%';
                mesa.style.height = '100%';
                mesa.style.margin = '0px';

                const button = document.createElement('div');
                button.textContent = 'X';
                button.className = 'close-button';

                button.addEventListener('click', function(event) {
                    event.stopPropagation();
                    const mesasContainer = document.getElementById('divCuadrados');
                    mesasContainer.appendChild(mesa);
                    button.remove();
                    mesa.style.width = '47px';
                    mesa.style.height = '47px';
                    mesa.style.margin = '1px';
                });

                mesa.appendChild(button);
                document.getElementById("mesaid-" + mesa.dataset.key).value = cuadro.dataset.posicion;
            } else {
                const mesasContainer = document.getElementById('divCuadrados');
                mesasContainer.appendChild(mesa);
            }
        }

        function generateUUID() {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                var r = Math.random() * 16 | 0, v = c === 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        }

        function inicializarMesas() {
            const mesasContainer = document.getElementById('divCuadrados');

            mesas.forEach(mesa => {
                var uuid = generateUUID();
                const mesaElement = document.createElement('div');
                mesaElement.classList.add('col-3');
                mesaElement.classList.add('mesa');
                mesaElement.id = `mesa-${uuid}`;
                mesaElement.textContent = `${mesa.nombre}`;
                mesaElement.style.color = '#000';
                mesaElement.dataset.key = uuid;
                mesaElement.dataset.mesaNombre = mesa.nombre;
                mesaElement.dataset.mesaSillas = mesa.sillas;
                mesaElement.dataset.eventoid = mesa.eventoid;
                if (window.innerWidth > 768) {
                    mesaElement.draggable = true;
                    mesaElement.addEventListener('dragstart', arrastrarMesa);
                } else {
                    mesaElement.draggable = false;
                }
                mesaElement.addEventListener('click', mostrarInfoMesa);

                // Crear un estilo dinámico para el pseudo-elemento
                const style = document.createElement('style');
                style.textContent = `
                    #mesa-${uuid}::before {
                        content: '';
                        background-image: url('${mesa.icono}');
                        background-position: center;
                        background-repeat: no-repeat;
                        background-size: 25px 25px;
                        position: absolute;
                        top: 50%;
                        left: 50%;
                        width: 40px;
                        height: 40px;
                        transform: translate(-50%, -50%);
                        opacity: 0.2;
                    }
                `;
                document.head.appendChild(style);

                const mesaInputPosicion = document.createElement('input');
                mesaInputPosicion.type = 'hidden';
                mesaInputPosicion.name = 'mesaposicion[]';
                mesaInputPosicion.id = `mesaid-${uuid}`;

                const mesaInputLayoutEvento = document.createElement('input');
                mesaInputLayoutEvento.type = 'hidden';
                mesaInputLayoutEvento.name = 'mesa_layout_evento[]';
                mesaInputLayoutEvento.value = mesa.eventoid;

                const mesaInputMesaId = document.createElement('input');
                mesaInputMesaId.type = 'hidden';
                mesaInputMesaId.name = 'mesa_id[]';
                mesaInputMesaId.value = mesa.id_mesa;

                mesaElement.appendChild(mesaInputMesaId);
                mesaElement.appendChild(mesaInputPosicion);
                mesaElement.appendChild(mesaInputLayoutEvento);
                mesasContainer.appendChild(mesaElement);
            });
        }

        function mostrarInfoMesa(event) {
            event.stopPropagation();
            const mesa = event.currentTarget;
            const existingSeccionId = $(mesa).find('input[name="seccion_id"]').val();
            const posicionInput = $(mesa).find('input[name="mesaposicion[]"]').val();
            let ubicacionInfo = '';

            if (posicionInput) {
                ubicacionInfo = `<p>Mesa ubicada en la posición: ${posicionInput}</p>`;
            } else {
                ubicacionInfo = '<p>Esta mesa no está ubicada en la cuadrícula.</p>';
            }

            const infoMesa = `
                <p>Nombre: ${mesa.dataset.mesaNombre}</p>
                <p>Sillas: ${mesa.dataset.mesaSillas}</p>
                <p>Evento ID: ${mesa.dataset.eventoid}</p>
                ${ubicacionInfo}
                <div class="form-group col-md-12 mb-3">
                    <label for="seccionesSelect">Seleccione una sección</label>
                    <select id="seccionesSelect" class="form-control">
                        <option selected disabled>Seleccione una opción</option>
                    </select>
                </div>
                <div class="form-group col-md-12 mb-3">
                    <label for="cuadroSelect">Selecciona el número del cuadro:</label>
                    <input type="number" id="cuadroSelect" min="1" max="266" class="form-control mb-2" value="${posicionInput || ''}">
                </div>
                <button id="colocarMesa" class="btn btn-success">Colocar Mesa</button>
                <button id="borrarMesa" class="btn btn-danger">Borrar Mesa</button>
            `;

            Swal.fire({
                icon: "info",
                title: "Datos",
                html: infoMesa,
                didOpen: () => {
                    const $select = $('#seccionesSelect');
                    secciones.forEach(function(seccion) {
                        const $option = $('<option>', {
                            value: seccion.id,
                            text: seccion.nombre
                        });
                        if (seccion.id === existingSeccionId) {
                            $option.attr('selected', 'selected');
                        }
                        $select.append($option);
                    });

                    $select.on('change', function() {
                        const selectedId = $(this).val();
                        const selectedSeccion = secciones.find(seccion => seccion.id === selectedId);

                        if (selectedSeccion) {
                            $(mesa).css('border', `5px solid ${selectedSeccion.color}`);
                            const inputSeccionId = $(mesa).find('input[name="seccion_id[]"]');
                            if (inputSeccionId.length === 0) {
                                $(mesa).append(`<input type="hidden" name="seccion_id[]" value="${selectedSeccion.id}">`);
                            } else {
                                inputSeccionId.val(selectedSeccion.id);
                            }
                        }
                    });

                    // Si ya hay una sección seleccionada, aplicar el borde correspondiente
                    if (existingSeccionId) {
                        const selectedSeccion = secciones.find(seccion => seccion.id === existingSeccionId);
                        if (selectedSeccion) {
                            $(mesa).css('border', `5px solid ${selectedSeccion.color}`);
                        }
                    }
                }
            });

            document.getElementById('colocarMesa').addEventListener('click', function() {
                const cuadroNum = document.getElementById('cuadroSelect').value;
                const cuadro = document.querySelector(`.cuadro[data-posicion="${cuadroNum}"]`);
                if (cuadro) {
                    cuadro.appendChild(mesa);
                    mesa.style.width = '100%';
                    mesa.style.height = '100%';
                    mesa.style.margin = '0px';

                    if (!mesa.querySelector('.close-button')) {
                        const button = document.createElement('div');
                        button.textContent = 'X';
                        button.className = 'close-button';
                        button.addEventListener('click', function(event) {
                            event.stopPropagation();
                            const mesasContainer = document.getElementById('divCuadrados');
                            mesasContainer.appendChild(mesa);
                            button.remove();
                            mesa.style.width = '47px';
                            mesa.style.height = '47px';
                            mesa.style.margin = '1px';
                        });
                        mesa.appendChild(button);
                    }
                    document.getElementById("mesaid-" + mesa.dataset.key).value = cuadroNum;
                }
                Swal.close();
            });

            document.getElementById('borrarMesa').addEventListener('click', function() {
                const mesasContainer = document.getElementById('divCuadrados');
                mesasContainer.appendChild(mesa);
                mesa.style.width = '47px';
                mesa.style.height = '47px';
                Swal.close();
            });
        }

        function arrastrarMesa(event) {
            event.dataTransfer.setData('text/plain', event.target.id);
        }

        function posicionarMesas() {
            mesasposicionadas.forEach(posicionada => {
                const mesaIndex = mesas.findIndex(m => m.id_mesa === posicionada.id_mesa);

                if (mesaIndex !== -1) {
                    const mesa = mesas[mesaIndex];
                    const key = generateUUID();

                    // Crear un elemento de mesa con los datos encontrados
                    const mesaElement = document.createElement('div');
                    mesaElement.classList.add('col-3');
                    mesaElement.classList.add('mesa');
                    mesaElement.id = `mesa-${key}`;
                    mesaElement.textContent = `${mesa.nombre}`;
                    mesaElement.style.color = '#000';
                    mesaElement.dataset.key = mesa.id_mesa;
                    mesaElement.dataset.mesaNombre = mesa.nombre;
                    mesaElement.dataset.mesaSillas = mesa.sillas;
                    mesaElement.dataset.eventoid = mesa.eventoid;
                    mesaElement.dataset.seccionId = posicionada.id_secion;
                    mesaElement.dataset.seccionColor = posicionada.color;

                    if (window.innerWidth > 768) {
                        mesaElement.draggable = true;
                        mesaElement.addEventListener('dragstart', arrastrarMesa);
                    } else {
                        mesaElement.draggable = false;
                    }
                    mesaElement.addEventListener('click', mostrarInfoMesa);

                    // Crear un estilo dinámico para el pseudo-elemento
                    const style = document.createElement('style');
                    style.textContent = `
                        #mesa-${key}::before {
                            content: '';
                            background-image: url('${mesa.icono}');
                            background-position: center;
                            background-repeat: no-repeat;
                            background-size: 25px 25px;
                            position: absolute;
                            top: 50%;
                            left: 50%;
                            width: 40px;
                            height: 40px;
                            transform: translate(-50%, -50%);
                            opacity: 0.2;
                        }
                    `;
                    document.head.appendChild(style);

                    // Inputs escondidos
                    const mesaInputPosicion = document.createElement('input');
                    mesaInputPosicion.type = 'hidden';
                    mesaInputPosicion.name = 'mesaposicion[]';
                    mesaInputPosicion.id = `mesaid-${mesaElement.dataset.key}`;
                    mesaInputPosicion.value = posicionada.posicion;

                    const mesaInputLayoutEvento = document.createElement('input');
                    mesaInputLayoutEvento.type = 'hidden';
                    mesaInputLayoutEvento.name = 'mesa_layout_evento[]';
                    mesaInputLayoutEvento.value = posicionada.idlayout_evento;

                    const mesaInputMesaId = document.createElement('input');
                    mesaInputMesaId.type = 'hidden';
                    mesaInputMesaId.name = 'mesa_id[]';
                    mesaInputMesaId.value = posicionada.id_mesa;

                    const mesaInputSeccionId = document.createElement('input');
                    mesaInputSeccionId.type = 'hidden';
                    mesaInputSeccionId.name = 'seccion_id[]';
                    mesaInputSeccionId.value = posicionada.id_secion;

                    mesaElement.appendChild(mesaInputMesaId);
                    mesaElement.appendChild(mesaInputPosicion);
                    mesaElement.appendChild(mesaInputLayoutEvento);
                    mesaElement.appendChild(mesaInputSeccionId);

                    // Añadir botón de cerrar
                    const button = document.createElement('div');
                    button.textContent = 'X';
                    button.className = 'close-button';
                    button.addEventListener('click', function(event) {
                        event.stopPropagation();
                        const mesasContainer = document.getElementById('divCuadrados');
                        mesasContainer.appendChild(mesaElement);
                        button.remove();
                        mesaElement.style.width = '47px';
                        mesaElement.style.height = '47px';
                        mesaElement.style.margin = '1px';
                    });
                    mesaElement.appendChild(button);

                    // Posicionar mesa en la cuadrícula
                    const cuadro = document.querySelector(`.cuadro[data-posicion="${posicionada.posicion}"]`);
                    if (cuadro) {
                        cuadro.appendChild(mesaElement);
                        mesaElement.style.width = '100%';
                        mesaElement.style.height = '100%';
                        mesaElement.style.margin = '0px';
                        mesaElement.style.border = `5px solid ${posicionada.color}`; // Aplicar el color de la sección
                        
                        // Eliminar el elemento de la derecha
                        const mesasContainer = document.getElementById('divCuadrados');
                        const mesaOriginal = mesasContainer.querySelector(`#mesa-${mesa.id_mesa}`);
                        if (mesaOriginal) {
                            mesasContainer.removeChild(mesaOriginal);
                        }
                        
                        // Eliminar la mesa del array para que no se duplique
                        mesas.splice(mesaIndex, 1);
                    }
                }
            });
        }

        function inicializar() {
            generarCuadricula(14, 19);
            if (typeof mesasposicionadas !== 'undefined' && mesasposicionadas.length > 0)
            {
                posicionarMesas();
            }
            inicializarMesas();
        }


        function createAndPreviewImage() {
            html2canvas(document.getElementById("cuadricula")).then(canvas => {
                var imgData = canvas.toDataURL('image/png');
                return imgData;
            }).catch(error => {
                console.error("Error al generar la imagen: ", error);
            });
        }

        window.onload = inicializar;

        let isPublished = false;

        $('#btn_guardar').on('click', function() {
            isPublished = false;
        });

        $('#btn_guardar_publicado').on('click', function() {
            isPublished = true;
        });

        $('body').on('submit', '.form_guardar', function(e) {
            e.preventDefault();
            var imgData = "";
            $('#lista_error').empty();

            html2canvas(document.getElementById("cuadricula")).then(canvas => {
                imgData = canvas.toDataURL('image/png');

                var formId = $(this).attr('id');
                var formData = new FormData(document.getElementById(formId));
                var url = $(`#${formId}`).attr('action');

                formData.append('imageData', imgData); // Añadir imagen como string base64

                // Verificar si se presionó el botón de publicar y agregar el campo publicado
                if (isPublished) {
                    formData.append('publicado', 1);
                }

                // Envío de Ajax con la imagen incluida
                $.ajax({
                    type: 'POST',
                    url: url,
                    contentType: false,
                    processData: false,
                    data: formData,
                    beforeSend: function() {
                        $("#btn_guardar").val("Enviando..");
                        $("#btn_guardar").attr("disabled", true);
                        $("#btn_guardar_publicado").val("Enviando..");
                        $("#btn_guardar_publicado").attr("disabled", true);
                        $("#loading-screen").removeClass('d-none');
                    }
                }).done(function(response) {
                    Swal.fire({
                        icon: response.icon,
                        title: response.title,
                        text: response.text,
                    });

                    if (response.lista != "") {
                        $(location).attr('href', response.lista);
                    }
                }).fail(function(response) {
                    console.log("fallo", response);

                    // Limpiar cualquier lista de errores existente
                    $('#lista_error').empty();

                    // Crear una lista ordenada
                    let $errorList = $('<ol></ol>');

                    // Iterar sobre los errores y agregarlos a la lista ordenada
                    $.each(response.responseJSON.errors, function(index, value) {
                        $.each(value, function(i, error) {
                            $errorList.append('<li class="error form-text text-danger"><b>' + error + '</b></li>');
                        });
                    });

                    // Añadir la lista de errores al contenedor con el ID 'lista_error'
                    $('#lista_error').append($errorList);

                    // Verificar y hacer parpadear las mesas si los inputs están vacíos o no existen
                    const inputsToCheck = ['mesa_id', 'mesaposicion', 'mesa_layout_evento', 'seccion_id'];
                    inputsToCheck.forEach(function(inputName) {
                        $('.mesa').each(function() {
                            const mesa = $(this);
                            const input = mesa.find(`input[name="${inputName}[]"]`);
                            if (input.length === 0 || input.val() === '') {
                                mesa.addClass('error-highlight');
                                setTimeout(function() {
                                    mesa.removeClass('error-highlight');
                                }, 5000);
                            }
                        });
                    });
                }).always(function() {
                    $("#btn_guardar").val("Guardar");
                    $("#btn_guardar").removeAttr("disabled");
                    $("#btn_guardar_publicado").val("Publicar");
                    $("#btn_guardar_publicado").removeAttr("disabled");
                    $("#loading-screen").addClass('d-none');
                });
            }).catch(error => {
                console.error("Error al generar la imagen: ", error);
            });
        });

        // Añadir la clase CSS para el efecto de parpadeo
        $('<style>')
            .prop('type', 'text/css')
            .html(`
                @keyframes blink {
                    0% { border-color: #f00; }
                    50% { border-color: #fff; }
                    100% { border-color: #f00; }
                }
                .error-highlight {
                    animation: blink 1s linear infinite;
                }
            `)
            .appendTo('head');

    </script>
</body>
</html>
