@extends('layout')

@section('content')



<!--script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.7.14/js/bootstrap-datetimepicker.min.js"></script-->

<!--se agregaron para los botones-->

<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/v/dt/jszip-2.5.0/dt-1.11.3/b-2.0.1/b-colvis-2.0.1/b-html5-2.0.1/cr-1.5.4/datatables.min.css" />

<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css"></script>
<script type="text/javascript" language="javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>


<!--se agregaron para los botones-->

<script type="text/javascript">
    $(function() {
        $('#datetimepicker').datetimepicker();
    });
</script>
<!--link rel="stylesheet" href="//code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css"-->
<!--link rel="stylesheet" href="/resources/demos/style.css"-->
<!--script src="https://code.jquery.com/jquery-3.6.0.js"></script>
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script-->
<script>
    $(document).ready(function() {



        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        })

        $('#tblDatos').DataTable({
                //autoWidth: true,
                destroy: true,
                ordering: true,
                sSearch: '<span class="kt-input-icon__icon kt-input-icon__icon--left"><span>&ensp;<i class="la la-search"></i></span>&ensp;Buscar</span >',
                language: {
                    sProcessing: "Procesando...",
                    sLengthMenu: "Mostrar _MENU_ registros",
                    sZeroRecords: "No se encontraron resultados",
                    sEmptyTable: "Ningún dato disponible en esta tabla",
                    sInfo: "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
                    sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
                    sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
                    sInfoPostFix: "",
                    sSearch: "Buscar:",
                    sUrl: "",
                    sInfoThousands: ",",
                    sLoadingRecords: "Cargando...",

                    oPaginate: {
                        sFirst: "Primero",
                        sLast: "Último",
                        sNext: "Siguiente",
                        sPrevious: "Anterior",
                    },
                },
                dom: 'lBfrtip',
                buttons: [
                    'copyHtml5', 'excelHtml5', 'pdfHtml5', 'csvHtml5'
                ]
            }


        ).draw();


        $("#datepicker").datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd/mm/yyyy',
            beforeShow: function(input, inst) {
                var $this = $(this);
                var cal = inst.dpDiv;
                var top = $this.offset().top + $this.outerHeight();
                var left = $this.offset().left;

                setTimeout(function() {
                    cal.css({
                        'top': top,
                        'left': left
                    });
                }, 10);
            }

        });


        $("#generarReporte").click(function() {

            var t = $('#tblDatos').DataTable({
                    //autoWidth: true,
                    destroy: true,
                    ordering: true,
                    sSearch: '<span class="kt-input-icon__icon kt-input-icon__icon--left"><span>&ensp;<i class="la la-search"></i></span>&ensp;Buscar</span >',
                    language: {
                        sProcessing: "Procesando...",
                        sLengthMenu: "Mostrar _MENU_ registros",
                        sZeroRecords: "No se encontraron resultados",
                        sEmptyTable: "Ningún dato disponible en esta tabla",
                        sInfo: "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
                        sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
                        sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
                        sInfoPostFix: "",
                        sSearch: "Buscar:",
                        sUrl: "",
                        sInfoThousands: ",",
                        sLoadingRecords: "Cargando...",
                        oPaginate: {
                            sFirst: "Primero",
                            sLast: "Último",
                            sNext: "Siguiente",
                            sPrevious: "Anterior",
                        },
                    },
                    dom: "lBfrtip",
                    buttons: [
                        'copyHtml5', 'excelHtml5', 'pdfHtml5', 'csvHtml5'
                    ]
                }

            );
            /*LIMPIAR DATATABLE*/
            t.clear().draw();


            var token = $("meta[name='csrf-token']").attr("content");
            var idSucursal = $("#idSucursal").val();
            var placas = $("#placas").val();
            var idmarca = $("#idMarca").val();
            var idlineas = $("#idLineas").val();
            var idcolor = $("#idColor").val();

            $.ajax({
                url: "/ReporteVehiculos/verDatos",
                type: 'POST',
                data: {
                    "idSucursal": idSucursal,
                    "placas": placas,
                    "idmarca": idmarca,
                    "idlineas": idlineas,
                    "idcolor": idcolor,
                    "_token": '{{csrf_token()}}',
                },
                success: function(resp) {

                    var arreglo = JSON.parse(resp);

                    console.log(arreglo);
                    for (var x = 0; x < arreglo.length; x++) {

                        t.row.add([
                            arreglo[x].sucursal,
                            arreglo[x].placas,
                            arreglo[x].marca,
                            arreglo[x].linea,
                            arreglo[x].color
                        ]).draw(true);



                    }


                    Toast.fire({
                        icon: 'success',
                        title: 'Reporte generado con éxito'
                    })
                }


            });
        });

        /*FUNCIÓN ONCLICK PARA EL BOTON DE ELIMINAR*/
        $(document).on('click', '[id^="placas-"]', function() {
            //var $button = $(this);
            var placas = this.id.split('-').pop();

            var div = document.getElementById('datosPlacas');
            div.style.display = "block"

            var divtabla = document.getElementById('divTabla');
            divtabla.style.display = "none";

            //var token = $("meta[name='csrf-token']").attr("content");
            $.ajax({
                url: "/Reportes/getVehiculo/" + placas,
                type: 'GET',
                data: {
                    "placas": placas,
                    "_token": '{{csrf_token()}}',
                },
                success: function(resp) {
                    var arreglo = JSON.parse(resp);

                    $('#tituloModal').text("Vehículo:");
                    $('#datoModal').text(arreglo[0].placas);
                    $('#tarjetamarca').text(arreglo[0].NombreMarca);
                    $('#tarjetalinea').text(arreglo[0].NombreLinea);
                    $('#tarjetacolor').text(arreglo[0].NombreColor);

                }


            });


        });


        /*FUNCIÓN ONCLICK PARA EL BOTON DE ELIMINAR*/
        $(document).on('click', '[id^="ticket-"]', function() {

            var divPlaca = document.getElementById('datosPlacas');
            divPlaca.style.display = "none"

            var divtablaTicket = document.getElementById('divTabla');
            divtablaTicket.style.display = "block";

            var id = this.id.split('-').pop();

            $('#tituloModal').text("iTicket:");
            $('#datoModal').text(id);
            $("#tblTickets").find("tr:gt(0)").remove();


            $.ajax({
                url: "/Reportes/verTicket/" + id,
                type: 'GET',
                data: {
                    "id": id,
                    "_token": '{{csrf_token()}}',
                },
                success: function(resp) {
                    var arreglo = JSON.parse(resp);

                    for (var x = 0; x < arreglo.length; x++) {

                        var todo = '<tr> <td>' + arreglo[x].status + '</td>';
                        todo += '<td>' + arreglo[x].empleado + ' </td>';
                        todo += '<td>' + arreglo[x].estacionamiento + ' </td>';
                        todo += '<td>' + arreglo[x].fecha + ' </td>';
                        todo += '<td>' + arreglo[x].detalles + ' </td> </tr>';

                        $('#tbodyModal').append(todo);
                    }

                }


            });


        });

        $('#idMarca').on('change', function() {
            
            var id = this.value;


            $.ajax({
                url: "/ReporteVehiculos/getLineas/" + id,
                type: 'GET',
                data: {
                    "id": id,
                    "_token": '{{csrf_token()}}',
                },
                success: function(resp) {
                    var arreglo = JSON.parse(resp);
                    
                    //alumnos.prop('disabled', false);

                    // Limpiamos el select
                    $('#idLineas').find('option').remove();
                    
                    $('#idLineas').append('<option value="-99">Seleccione un modelo</option>');

                    $(arreglo).each(function(i, v){ // indice, valor
                        $('#idLineas').append('<option value="' + v.id + '">' + v.nombre + '</option>');
                    })

                    $('#idLineas').prop('disabled', false);

                }


            });


        });

    });
</script>

<div class="d-flex flex-column-fluid">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Card-->
        <div class="card card-custom">
            <!--begin::Header-->
            <div class="card-header flex-wrap border-0 pt-6 pb-0">
                <div class="card-title">
                    <h3 class="card-label">Reportes
                        <span class="d-block text-muted pt-2 font-size-sm">ITickets</span>
                    </h3>
                </div>
                <div class="card-toolbar">
                    <!--begin::Dropdown-->
                    <div class="dropdown dropdown-inline mr-2">

                        <div class="dropdown-menu dropdown-menu-sm dropdown-menu-right">
                            <!--begin::Navigation-->
                            <ul class="navi flex-column navi-hover py-2">
                                <li class="navi-header font-weight-bolder text-uppercase font-size-sm text-primary pb-2">Choose an option:</li>
                                <li class="navi-item">
                                    <a href="#" class="navi-link">
                                        <span class="navi-icon">
                                            <i class="la la-print"></i>
                                        </span>
                                        <span class="navi-text">Print</span>
                                    </a>
                                </li>
                                <li class="navi-item">
                                    <a href="#" class="navi-link">
                                        <span class="navi-icon">
                                            <i class="la la-copy"></i>
                                        </span>
                                        <span class="navi-text">Copy</span>
                                    </a>
                                </li>
                                <li class="navi-item">
                                    <a href="#" class="navi-link">
                                        <span class="navi-icon">
                                            <i class="la la-file-excel-o"></i>
                                        </span>
                                        <span class="navi-text">Excel</span>
                                    </a>
                                </li>
                                <li class="navi-item">
                                    <a href="#" class="navi-link">
                                        <span class="navi-icon">
                                            <i class="la la-file-text-o"></i>
                                        </span>
                                        <span class="navi-text">CSV</span>
                                    </a>
                                </li>
                                <li class="navi-item">
                                    <a href="#" class="navi-link">
                                        <span class="navi-icon">
                                            <i class="la la-file-pdf-o"></i>
                                        </span>
                                        <span class="navi-text">PDF</span>
                                    </a>
                                </li>
                            </ul>
                            <!--end::Navigation-->
                        </div>
                        <!--end::Dropdown Menu-->
                    </div>
                    <!--end::Dropdown-->
                    <!--begin::Button-->

                    <!--end::Button-->
                </div>
            </div>
            <!--end::Header-->
            <!--begin::Body-->

            <div id="filtros" class="card-body">
                <div class="form-group row">
                    <label class="col-1 form-label col text-lg-right text-left">Sucursal</label>
                    <div class="col-6">
                        <div class="input-group input-group-lg input-group-solid">
                            <select id="idSucursal" name="idSucursal" class="form-control form-control-lg form-control-solid">
                                <option value="-99">Seleccione una sucursal</option>
                                @foreach($sucursales as $sucursal)
                                <option value="{{$sucursal->id}}">{{$sucursal->nombre}}</option>
                                @endforeach
                            </select>
                        </div>

                    </div>
                </div>


                <div class="form-group row">
                    <label class="col-1 form-label col text-lg-right text-left">Placa:</label>
                    <div class="col-2">
                        <div class="input-group input-group-lg input-group-solid">
                            <div class="input-group">
                                <input id="placas" name="placas" type="text" class="form-control" name="placas" type="text">
                                <div class="input-group-addon">
                                    <span class="glyphicon glyphicon-th"></span>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>


                <div class="form-group row">
                    <label class="col-1 form-label col text-lg-right text-left">Marcas:</label>
                    <div class="col-4">
                        <div class="input-group input-group-lg input-group-solid">
                            <select id="idMarca" name="idMarca" class="form-control form-control-lg form-control-solid">
                                <option value="-99">Seleccione una marca</option>
                                @foreach($marcas as $marca)
                                <option value="{{$marca->id}}">{{$marca->nombre}}</option>
                                @endforeach
                            </select>
                        </div>

                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-1 form-label col text-lg-right text-left">Modelo:</label>
                    <div class="col-4">
                        <div class="input-group input-group-lg input-group-solid">
                            <select id="idLineas" name="idLineas" class="form-control form-control-lg form-control-solid">
                                <option value="-99">Seleccione un Modelo</option>                                 
                            </select>
                        </div>

                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-1 form-label col text-lg-right text-left">Color:</label>
                    <div class="col-6">
                        <div class="input-group input-group-lg input-group-solid">
                            <select id="idColor" name="idColor" class="form-control form-control-lg form-control-solid">
                                <option value="-99">Seleccione una color</option>
                                @foreach($colores as $color)
                                <option value="{{$color->id}}">{{$color->nombre}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-2">
                        <button id="generarReporte" class="btn btn-primary">Generar reporte</button>
                    </div>
                </div>


            </div>

            <div class="card-body">
                <!--begin: Datatable-->
                <!--div class="datatable datatable-bordered datatable-head-custom" id="kt_datatable"></div-->
                <!--end: Datatable-->

                <table class="table border" id="tblDatos">
                    <thead>
                        <tr>
                            <th>Sucursal</th>
                            <th>Placa</th>
                            <th>Marca</th>
                            <th>Modelo</th>
                            <th>Color</th>
                        </tr>
                    </thead>
                    <tbody id="tbody">


                    </tbody>
                </table>

            </div>
            <!--end::Body-->
        </div>
        <!--end::Card-->
    </div>
    <!--end::Container-->
</div>

@include('Reportes.tarjetaVehiculo')

@endsection