<script>
	$(document).ready(function() {
		$('#tblBeneficios').DataTable({
			destroy: true,
			ordering: true,
			sSearch: '<span class="kt-input-icon__icon kt-input-icon__icon--left"><span>&ensp;<i class="la la-search"></i></span>&ensp;Buscar</span >',
			language: {
				sProcessing: "Procesando...",
				sLengthMenu: "Mostrar _MENU_ registros",
				sZeroRecords: "No se encontraron resultados",
				sEmptyTable: "Ningún dato disponible en esta tabla",
				sInfo: "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
				sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
				sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
				sInfoPostFix: "",
				sSearch: "Buscar:",
				sUrl: "",
				sInfoThousands: ",",
				sLoadingRecords: "Cargando...",
				oPaginate: {
					sFirst: "Primero",
					sLast: "Último",
					sNext: "Siguiente",
					sPrevious: "Anterior",
				},
			},
		}).draw();
	});

	/*FUNCIÓN ONCLICK PARA EL BOTON DE ELIMINAR*/
	$(document).on('click', '[id^="btnEliminar-"]', function() {
		var $button = $(this);
		var id = this.id.split('-').pop();

		var table = $('#tblBeneficios').DataTable(); // replace with your table id        

		const swalWithBootstrapButtons = Swal.mixin({
			customClass: {
				confirmButton: 'btn btn-success',
				cancelButton: 'btn btn-danger'
			},
			buttonsStyling: false
		})

		const Toast = Swal.mixin({
			toast: true,
			position: 'top-end',
			showConfirmButton: false,
			timer: 3000,
			timerProgressBar: true,
			didOpen: (toast) => {
				toast.addEventListener('mouseenter', Swal.stopTimer)
				toast.addEventListener('mouseleave', Swal.resumeTimer)
			}
		})

		swalWithBootstrapButtons.fire({
			title: '¿Desea eliminar el siguiente registro?',
			text: "Esta acción no es reversible.",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'Sí, Eliminar',
			cancelButtonText: 'No, cancelar',
			reverseButtons: true
		}).then((result) => {
			if (result.isConfirmed) {

				var token = $("meta[name='csrf-token']").attr("content");

				$.ajax({
					url: "{{url('beneficios')}}" + "/" + id,
					type: 'DELETE',
					data: {
						_token: '{{csrf_token()}}',
					},
					success: function() {
						table.row($button.parents('tr')).remove().draw();
						Toast.fire({
							icon: 'success',
							title: 'Registro eliminado'
						})

					}
				});
			}
		})

	});
</script>

<table class="table border" id="tblBeneficios">
	<thead>
		<tr>
			<th>Estado</th>
			<th>Nombre</th>
			<th>Descripción</th>
			<th>Código</th>
			@can('editar_beneficios')
			<th>Editar</th>
			@endcan
			@can('eliminar_beneficios')
			<th>Eliminar</th>
			@endcan
		</tr>
	</thead>
	<tbody>
		@foreach($beneficios as $beneficio)
		<tr>
			<td>{{ $beneficio->estado }}</td>
			<td>{{ $beneficio->nombre }}</td>
			<td>{{ $beneficio->descripcion }}</td>
			<td>{{ $beneficio->codigo }} </td>
			@can('editar_beneficios')
			<td>
				<a class="btn btn-warning" href="{{url('/beneficios/'.$beneficio->id.'/edit')}}">
					<i class="fa-solid fa-pen-to-square"></i>
				</a>
			</td>
			@endcan
			@can('eliminar_beneficios')
			<td>
				<button class="btn btn-danger" id="btnEliminar-{{$beneficio->id}}"><i class="fa-solid fa-circle-minus"></i></button>
			</td>
			@endcan
		</tr>
		@endforeach
	</tbody>
</table>