@extends('layout')

@section('content')
<script type="text/javascript">
	$(function(){
		$('#nivel').on('change', function(){
			let nivel = $('#nivel').val();
			console.log(nivel);
			if(nivel != ''){
				$.ajax({
					url: "{{ url('beneficios/list/') }}" + '/' + nivel,
					data: {
						_token: '{{csrf_token()}}',
					},
					success: function(e) {
						$('#lista').html(e);
						$('#nuevo-beneficio').show();
					},
					error: function(e){
						console.log(e);
						Toast.fire({
							icon: 'error',
							title: 'Ocurrió un error, vuelva a intentarlo'
						});
					}

				});
			}else{
				$('#lista').html('');
				$('#nuevo-beneficio').hide();
			}
		});
		$('#nuevo-beneficio').on('click', function(){
			location.href = '{{ route('beneficios.create') }}' + '?nivel=' + $('#nivel').val();
		});
		
		$('#nivel').trigger('change');
	});
</script>
<div class="d-flex flex-column-fluid">
	<!--begin::Container-->
	<div class="container">
		<!--begin::Card-->
		<div class="card card-custom">
			<!--begin::Header-->
			<div class="card-header flex-wrap border-0 pt-6 pb-0">
				<div class="card-title">
					<h3 class="card-label">Beneficios</h3>
				</div>
			</div>
			<!--end::Header-->
			<!--begin::Body-->
			<div class="card-body">
				<div class="row">
					<div class="col-md-3"></div>
					<div class="col-md-6">
						<label for="">Nivel</label>
						<select class="form-control form-control-lg form-control-solid" id="nivel">
							{{-- <option value="">Seleccione...</option> --}}
							@foreach($niveles as $nivel)
							<option value="{{ $nivel->id }}" {{ session('seleccion-nivel') == $nivel->id ? 'selected' : '' }}>{{ $nivel->nombre }}</option>
							@endforeach
						</select>
					</div>
					<div class="col-md-3"></div>
				</div>
				<div class="row mt-5">
					<div class="col-md-12 text-right">
						@can('crear_beneficios')
						<button type="button" class="btn btn-primary font-weight-bolder" style="display: none;" id="nuevo-beneficio">
							<span class="svg-icon svg-icon-md">
								<!--begin::Svg Icon | path:assets/media/svg/icons/Design/Flatten.svg-->
								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
									<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
										<rect x="0" y="0" width="24" height="24" />
										<circle fill="#000000" cx="9" cy="15" r="6" />
										<path d="M8.8012943,7.00241953 C9.83837775,5.20768121 11.7781543,4 14,4 C17.3137085,4 20,6.6862915 20,10 C20,12.2218457 18.7923188,14.1616223 16.9975805,15.1987057 C16.9991904,15.1326658 17,15.0664274 17,15 C17,10.581722 13.418278,7 9,7 C8.93357256,7 8.86733422,7.00080962 8.8012943,7.00241953 Z" fill="#000000" opacity="0.3" />
									</g>
								</svg>
								<!--end::Svg Icon-->
							</span>Nuevo beneficio
						</button>
						@endcan
					</div>
				</div>
			</div>
			<div class="card-body" id="lista">
				
			</div>
			<!--end::Body-->
		</div>
		<!--end::Card-->
	</div>
	<!--end::Container-->
</div>
@endsection