<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIticketTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('iticket', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('idvehiculo')->nullable()->unsigned();
            $table->integer('idcompany')->nullable()->unsigned();
            $table->integer('idsucursal')->nullable()->unsigned();
            $table->integer('idempleado')->nullable()->unsigned();
            $table->integer('idcliente')->nullable()->unsigned();
            $table->boolean('activo')->nullable();
            $table->string('token')->nullable();
            $table->integer('idstatusvehiculo')->nullable()->unsigned();
            $table->integer('idestacionamientocajon')->nullable()->unsigned();
            $table->timestamps();
            $table->foreign('idvehiculo')->references('id')->on('vehiculos')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idcompany')->references('id')->on('company')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idsucursal')->references('id')->on('sucursal')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idempleado')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idcliente')->references('id')->on('clientes')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idstatusvehiculo')->references('id')->on('statusvehiculo')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idestacionamientocajon')->references('id')->on('estacionamientocajon')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ticket');
    }
}
