<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVehiculosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehiculos', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('idcompany')->nullable()->unsigned();
            $table->integer('idsucursal')->nullable()->unsigned();
            $table->string('placas', 10)->nullable();
            $table->integer('idmarca')->unsigned()->nullable();
            $table->integer('idlinea')->unsigned()->nullable();
            $table->integer('idcolor')->unsigned()->nullable();
            $table->string('modelo')->nullable();
            $table->text('observaciones')->nullable();
            $table->text('img_frente')->nullable();
            $table->text('img_izq')->nullable();
            $table->text('img_der')->nullable();
            $table->text('img_atras')->nullable();
            $table->foreign('idcompany')->references('id')->on('company')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idsucursal')->references('id')->on('sucursal')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idmarca')->references('id')->on('marca')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idlinea')->references('id')->on('linea')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idcolor')->references('id')->on('color')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehiculos');
    }
}
