<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VehiculoValet extends Model
{
    public $table = 'vehiculo_valet';
    
    protected $fillable = [
        'detalles',
        'fecha_asignacion',
        'fecha_inicio',
        'fecha_fin',
        'actividad',
    ];
    
    protected $casts = [
        'detalles' => 'string',
        'fecha_asignacion' => 'string',        
        'fecha_inicio' => 'string',
        'fecha_fin' => 'string',
        'actividad' => 'string',
    ];

    public function vehiculo()
    {
        return $this->belongsTo(\App\Models\Vehiculo::class, 'idvehiculo', 'id');
    }

    public function user()
    {
        return $this->belongsTo(\App\Models\User::class, 'idempleado', 'id');
    }

    public function cliente()
    {
        return $this->belongsTo(\App\Models\Cliente::class, 'idcliente', 'id');
    }
}
