<?php

namespace App\Models;


use Illuminate\Foundation\Auth\User as Authenticatable;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Traits\HasPermissions;


class User extends Authenticatable
{
    use HasRoles;
	use HasPermissions;

    public $table = 'users';

    public $fillable = [
        'nombre',
        'apellido',
        'codigo',
        'celular',
        'email',
        'password',
        'api_token',
        'device_token',
        'remember_token',
        'idrol',
        'idsucursal',
		'idsucursal_nombre',
        'rol',
    ];

    protected $casts = [
        'nombre' => 'string',
        'apellido' => 'string',        
        'celular' => 'string',
        'codigo' => 'string',
        'email'=> 'string',
        'password' => 'string',
        'api_token' => 'string',
        'device_token' => 'string',
        'remember_token' => 'string',
        'idrol' => 'integer',
        'idsucursal' => 'integer',
		'idsucursal_nombre'=> 'string',
        'rol'=> 'string',
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];

    public function sucursal(){
        return $this->belongsTo(Sucursal::class, 'idsucursal');
    }

    public function getFullNameAttribute(){
        return "$this->nombre $this->apellido";
    }
}
