<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RecompensaSucursal extends Model
{
    public $timestamps = false;
    
    public $table = 'recompensa_sucursal';

    public $fillable = [
        'idrecompensa',
        'idsucursal',
    ];

    protected $casts = [
        'idrecompensa' => 'int',
        'idsucursal' => 'int',
    ];

    public function recompensa()
    {
        return $this->belongsTo(Recompensa::class, 'idrecompensa');
    }

    public function sucursal()
    {
        return $this->belongsTo(Sucursal::class, 'idsucursal');
    }
}
