<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RecompensaPromocional extends Model
{
    use SoftDeletes;

    public $table = 'recompensa_promocional';

    public $fillable = [
        'id',
        'idrecompensa',
        'nombre',
        'descripcion',
        'codigo',
        'valor',
        'imagen',
    ];

    protected $casts = [
        'id' => 'int',
        'idrecompensa' => 'int',
        'nombre' => 'string',
        'descripcion' => 'string',
        'codigo' => 'string',
        'valor' => 'int',
        'imagen' => 'string',
    ];

    public function recompensa()
    {
        return $this->belongsTo(Recompensa::class, 'idrecompensa');
    }
}
