<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Recompensa extends Model
{
    use SoftDeletes;

    public $table = 'recompensa';

    public $fillable = [
        'id',
        'status',
        'idrecompensa_categoria',
        'nombre',
        'inicio_fecha',
        'inicio_hora',
        'fin_fecha',
        'fin_hora',
    ];

    protected $casts = [
        'id' => 'int',
        'status' => 'boolean',
        'idrecompensa_categoria' => 'int',
        'nombre' => 'string',
        'inicio_fecha' => 'string',
        'inicio_hora' => 'string',
        'fin_fecha' => 'string',
        'fin_hora' => 'string',
    ];

    public function categoria()
    {
        return $this->belongsTo(RecompensaCategoria::class, 'idrecompensa_categoria');
    }

    public function promocional()
    {
        return $this->hasMany(RecompensaPromocional::class, 'idrecompensa');
    }

    public function recompensaSucursal()
    {
        return $this->hasMany(RecompensaSucursal::class, 'idrecompensa');
    }

    public function sucursal()
    {
        return $this->belongsToMany(Sucursal::class, 'recompensa_sucursal', 'idrecompensa', 'idsucursal');
    }

    public function getEstadoAttribute(){
        return $this->status ? 'Activa' : 'Inactiva';
    }
}
