<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PromocionSucursal extends Model
{
    public $timestamps = false;
    
    public $table = 'promocion_sucursal';

    public $fillable = [
        'idpromocion',
        'idsucursal',
    ];

    protected $casts = [
        'idpromocion' => 'int',
        'idsucursal' => 'int',
    ];

    public function promocion()
    {
        return $this->belongsTo(Promocion::class, 'idpromocion');
    }

    public function sucursal()
    {
        return $this->belongsTo(Sucursal::class, 'idsucursal');
    }
}
