<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PromocionNotificacion extends Model
{
    public $timestamps = false;
    
    public $table = 'promocion_notificacion';

    public $fillable = [
        'id',
        'idpromocion',
        'fecha_notificacion',
        'enviado',
        'titulo',
        'mensaje',
        'sucursales',
        'id_promocion_foliatti'

    ];

    protected $casts = [
        'id' => 'int',
        'idpromocion' => 'int',
        'fecha_notificacion' => 'string',
        'enviado' => 'boolean',
        'titulo' => 'string',
        'mensaje' => 'string',
        'sucursales' => 'string',
        'id_promocion_foliatti' => 'int'

    ];

    public function promocion()
    {
        return $this->belongsTo(Promocion::class, 'idpromocion');
    }

}
