<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Promocion extends Model
{
    use SoftDeletes;

    public $table = 'promocion';

    public $fillable = [
        'id',
        'status',
        'tipo',
        'nombre',
        'imagen_mini',
        'imagen',
        'updated_by',
        'hasnotificaciones',
        'beneficio_nivel_id',
        'f_lun',
        'f_mar',
        'f_mie',
        'f_jue',
        'f_vie',
        'f_sab',
        'f_sab',
        'not_hora',
        'not_mensaje',
        'fecha_inicio',
        'hora_inicio',
        'fecha_fin',
        'hora_fin',
        'tipo_f',
        'codigo',
        'incompleto'


    ];

    protected $casts = [
        'id' => 'int',
        'status' => 'boolean',
        'tipo' => 'int',
        'nombre' => 'string',
        'imagen_mini' => 'string',
        'imagen' => 'string',
        'updated_by' => 'int',
        'hasnotificaciones' => 'boolean',
        'beneficio_nivel_id' => 'int',
        'f_lun' => 'boolean',
        'f_mar' => 'boolean',
        'f_mie' => 'boolean',
        'f_jue' => 'boolean',
        'f_vie' => 'boolean',
        'f_sab' => 'boolean',
        'f_dom' => 'boolean',
        'not_hora' => 'string',
        'not_mensaje' => 'string',
        'fecha_inicio' => 'string',
        'hora_inicio' => 'string',
        'fecha_fin' => 'string',
        'hora_fin' => 'string',
        'tipo_f' => 'string',
        'codigo' => 'int',
        'incompleto' => 'boolean'
    ];

    public function promocionSucursal()
    {
        return $this->hasMany(PromocionSucursal::class, 'idpromocion');
    }

    public function promocionNotificacion()
    {
        return $this->hasMany(PromocionNotificacion::class, 'idpromocion');
    }

    public function sucursal()
    {
        return $this->belongsToMany(Sucursal::class, 'promocion_sucursal', 'idpromocion', 'idsucursal');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function getEstadoAttribute()
    {
        return $this->status ? 'Activo' : 'Inactivo';
    }

    public function getTipoNombreAttribute()
    {
        return $this->tipo == 1 ? 'Promociones' : 'Noticias';
    }
}
