<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;

class ClienteSucursal extends Authenticatable
{
    
    public $table = 'cliente_sucursal';
    
    protected $fillable = [
        'id',
        'idcliente',
        'idsucursal',
        'fechavinculacion',
        'favorito'
       
    ];
    
    protected $casts = [
    ];
    
    protected $hidden = [
    ];

    
    public function cliente()
    {
        return $this->belongsTo(\App\Models\Cliente::class, 'idcliente', 'id');
    }

    public function sucursal()
    {
        return $this->belongsTo(\App\Models\Sucursal::class, 'idsucursal', 'id');
    }

}
