<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Sucursal;
use App\Models\Marca;
use App\Models\Linea;
use App\Models\Color;
use Illuminate\Support\Facades\DB;

class reporteVehiculosController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('permission:reporte_vehiculos', ['only' => ['index']]);
         
    }
    //
    public function index()
    {
        //        
        $sucursales = Sucursal::all(); 
        $marcas = Marca::all();    
        $lineas = Linea::all();    
        $colores = Color::all();    

        return view('Reportes.reporteVehiculos', compact('sucursales','marcas','lineas','colores'));
    }

    public function verDatos(Request $request)
    {

        $idSucursal = $request->idSucursal;
        $placas = $request->placas;
        $idMarca = $request->idmarca;        
        $idLineas = $request->idlineas;
        $idColor = $request->idcolor; 
                  

        $sql = 'select sucursal.nombre as sucursal,placas,marca.nombre as marca,linea.nombre as linea,
        color.nombre as color  from vehiculos
        left join sucursal on sucursal.id = vehiculos.idsucursal
        left join marca on marca.id = vehiculos.idmarca
        left join linea on linea.id = vehiculos.idlinea
        left join color on color.id = vehiculos.idcolor ' . 
        'WHERE vehiculos.idsucursal = CASE ' . $idSucursal . ' WHEN -99 THEN vehiculos.idsucursal ELSE ' . $idSucursal . ' END ' .
        'and vehiculos.idmarca = CASE ' . $idMarca . ' WHEN -99 THEN vehiculos.idmarca ELSE ' . $idMarca . ' END ' . 
        'and vehiculos.idlinea = CASE ' . $idLineas . ' WHEN -99 THEN vehiculos.idlinea ELSE ' . $idLineas . ' END ' . 
        'and vehiculos.idcolor = CASE ' . $idColor . ' WHEN -99 THEN vehiculos.idcolor ELSE ' . $idColor . ' END ' ;

             

            if(!empty($placas)){
                $sql = $sql . ' and vehiculos.placas like  \'%' . $placas .'%\'';
            }
            

        $reporte = DB::select($sql);

        return response(json_encode($reporte), 200)->header('Content-type', 'text/plain');
        
       
    }

    public function getLineas($id){
        $Lineas = Linea::where('idmarca', $id)->get();
        
    return response(json_encode($Lineas), 200)->header('Content-type', 'text/plain');
    
        /*if (empty($vehiculo)) {
            return $this->sendError('Vehiculo no encontrado');
        }else {
            return $this->sendResponse($vehiculo, 'Vehiculo encontrado');
        }*/   
    }

}
