<?php

namespace App\Http\Controllers;

use App\Exceptions\InvalidRequestException;
use App\Models\Roles;
use App\Models\Sucursal;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Routing\Route; //18-03-2022
use App\Http\Controllers\exception;
use App\Http\Controllers\Permission;

use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Authh;
use Illuminate\Support\Facades\Auth;

class UsersController extends Controller
{


    use HasRoles;

    public function __construct()
    {
        $this->middleware('permission:crear_usuarios', ['only' => ['create']]);
        $this->middleware('permission:editar_usuarios', ['only' => ['edit']]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        //return view("User.Users_create");

        //throw new \Exception('El producto no está en los estantes');

        try {

            $id = Auth::id();

            $usuarioAuth = User::find($id);
            $users = User::permission('ver_todas_sucursales')->get();
            $rolAsignado = $usuarioAuth->roles()->first()->name;
            $tienePermiso = $usuarioAuth->hasPermissionTo('ver_todas_sucursales');

            //echo $usuarioAuth->roles()->get();

            //throw new InvalidRequestException($stringvalors);
            if ($tienePermiso > 0) {
                //Ver todas las sucursales
                //$usuarios = User::all();
                $sql = 'select users.id,users.nombre,users.apellido,users.codigo,celular,idsucursal,sucursal.nombre as sucursal,users.status, roles.name as rol
            from users 
            inner join sucursal on  users.idsucursal = sucursal.id
			inner join roles on users.idrol = roles.id where users.deleted_at is null';
            } else {

                $sql = 'select users.id,users.nombre,users.apellido,users.codigo,celular,idsucursal,sucursal.nombre as sucursal,users.status, roles.name as rol
            from users 
            inner join sucursal on  users.idsucursal = sucursal.id
			inner join roles on users.idrol = roles.id 
            where users.deleted_at is null and idsucursal = ' . $usuarioAuth->idsucursal;
            }

            $usuarios = DB::select($sql);

            $sucursales = Sucursal::all();
        } catch (\Exception $e) {

            throw new InvalidRequestException($e->getMessage());
        }



        return view('User.users_list', compact('usuarios', 'sucursales'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $error = "";
        $roles = Roles::all();

        $sucursales = Sucursal::all();


        return view('User.Users_create', compact('error', 'roles', 'sucursales'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //           
        $usuario = User::where('celular', $request->celular)->get();
        $email = User::where('email', $request->email)->get();

        try {


            if (count($usuario) > 0) {
                $error = "Ya existe un usuario con ese número de celular, por favor verifique.";
                throw new InvalidRequestException($error);
            }
            if (count($email) > 0) {
                $error = "Ya existe un usuario con ese correo electronico, por favor verifique.";
                throw new InvalidRequestException($error);
            }

            $usuarionuevo = User::create([
                'nombre' => $request->nombre,
                'apellido' => $request->apellido,
                'codigo' => $request->codigo,
                'password' => Hash::make($request->password),
                'celular' => $request->celular,
                'email' => $request->email,
                'status' => $request->status,
                'idrol' => $request->idrol,
                'idsucursal' => $request->idsucursal

            ]);

            $idUser = $usuarionuevo->id;
            $usuarionuevo->api_token = $usuarionuevo->password;
            $usuarionuevo->idempleo = 1;
            $usuarionuevo->idcompany = 1;
            $usuarionuevo->status = true;   
            $usuarionuevo->save();

            /*asignar rol al usuario*/

            $user = User::find($idUser);
            $user->assignRole($request->idrol); //asignar rol 21-04-2022

        } catch (\Exception $e) {

            throw new InvalidRequestException($e->getMessage());
        }

        return redirect()->route("Usuarios.index")->with(["mensaje" => "Usuario creado",]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //        
        $user = User::findOrFail($id);
        $roles = Roles::all();
        //$user->assignRole('valetAdmin'); //asignar rol 21-04-2022
        $id = Auth::id();

        $usuarioAuth = User::find($id);
        $users = User::permission('ver_todas_sucursales')->get();
        $rolAsignado = $usuarioAuth->roles()->first()->name;
        $tienePermiso = $usuarioAuth->hasPermissionTo('ver_todas_sucursales');

        
        if( $tienePermiso > 0){
            /*si tiene el permiso puede ver tiodas las sucursales*/
            $sucursales = Sucursal::all();
        }else{
            /*solo puede ver su sucursal*/
            //$sucursales = Sucursal::all();
            $sucursales[] = Sucursal::findOrFail($usuarioAuth->idsucursal);
        }
         
        return view('User.Users_edit', compact('user', 'roles', 'sucursales'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
    }

    public function actualizarusuario(Request $request)
    {
        $datosUser = request()->except(['_token', '_method']);

        $usuario = User::where('celular', $request->celular)
            ->where('id', '!=', $request->id)
            ->get();
        $email = User::where('email', $request->email)
            ->where('id', '!=', $request->id)
            ->get();

        try {
            if (count($usuario) > 0) {
                $error = "Ya existe un usuario con ese número de celular, por favor verifique.";
                throw new InvalidRequestException($error);
            }
            if (count($email) > 0) {
                $error = "Ya existe un usuario con ese correo electronico, por favor verifique.";
                throw new InvalidRequestException($error);
            }

            DB::table('users')
                ->where('id', $request->id)
                ->update([
                    'nombre' => $request->nombre,
                    'apellido' => $request->apellido,
                    'codigo' => $request->codigo,
                    'celular' => $request->celular,
                    'status' => $request->status,
                    'idrol' => $request->idrol,
                    'email' => $request->email,
                    'idsucursal' => $request->idsucursal
                ]);

            /*asiganr rol spatie*/
            $user = User::find($request->id);
            $user->syncroles($request->idrol); //asignar rol 21-04-2022

            /*Actualizar la contraseña si trae datos el campo */
            if (empty(!$request->password)) {
                DB::table('users')
                    ->where('id', $request->id)
                    ->update([
                        'password' => Hash::make($request->password),
                    ]);
            }
        } catch (\Exception $e) {

            throw new InvalidRequestException($e->getMessage());
        }

        //$roles = Roles::all();

        return redirect()->route("Usuarios.index")->with(["mensaje" => "Usuario creado",]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //User::destroy($id);

        //$usuarios = User::all();
        //$usuariomodificar = User::findOrFail($id);
        User::where('id', $id)->update(['deleted_at' => now()]);



        $idLogin = Auth::id();

        $usuarioAuth = User::find($idLogin);
        $users = User::permission('ver_todas_sucursales')->get();
        $rolAsignado = $usuarioAuth->roles()->first()->name;
        $tienePermiso = $usuarioAuth->hasPermissionTo('ver_todas_sucursales');

        //echo $usuarioAuth->roles()->get();

        //throw new InvalidRequestException($stringvalors);
        if ($tienePermiso > 0) {
            //Ver todas las sucursales
            //$usuarios = User::all();
            $sql = 'select users.id,users.nombre,users.apellido,users.codigo,celular,idsucursal,sucursal.nombre as sucursal,users.status, roles.name as rol
        from users 
        inner join sucursal on  users.idsucursal = sucursal.id
        inner join roles on users.idrol = roles.id where users.deleted_at is null';
        } else {

            $sql = 'select users.id,users.nombre,users.apellido,users.codigo,celular,idsucursal,sucursal.nombre as sucursal,users.status, roles.name as rol
        from users 
        inner join sucursal on  users.idsucursal = sucursal.id
        inner join roles on users.idrol = roles.id 
        where users.deleted_at is null and idsucursal = ' . $usuarioAuth->idsucursal;
        }

        $usuarios = DB::select($sql);

/*
        $sql = 'select users.id,users.nombre,users.apellido,users.codigo,celular,idsucursal,sucursal.nombre as sucursal,users.status
            from users 
            inner join sucursal on  users.idsucursal = sucursal.id where users.deleted_at is null';

        $usuarios = DB::select($sql);
*/

        return view('User.users_list', compact('usuarios'));
    }


    public function modificarestatus($id)
    {
        $estatus_nuevo = '';

        $usuariomodificar = User::findOrFail($id);

        if ($usuariomodificar->status == true) {
            $estatus_nuevo = 'false';
        } else {
            $estatus_nuevo = 'true';
        }

        DB::table('users')
            ->where('id', $id)
            ->update([
                'status' => $estatus_nuevo
            ]);



            
        $sql = 'select users.id,users.nombre,users.apellido,users.codigo,celular,idsucursal,sucursal.nombre as sucursal,users.status, roles.name as rol
            from users 
            inner join sucursal on  users.idsucursal = sucursal.id
			inner join roles on users.idrol = roles.id';

        $usuarios = DB::select($sql);

        return view('User.users_list', compact('usuarios'));
    }
}
