<?php

namespace App\Http\Controllers;

use App\Exceptions\InvalidRequestException;
use App\Models\Roles;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Routing\Route;
use App\Http\Controllers\exception;
use App\Http\Controllers\Permission;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Authh;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Models\Promocion;
use App\Models\PromocionSucursal;
use App\Models\Sucursal;

class NoticiasController extends Controller
{
    use HasRoles;

    public function __construct()
    {
        $this->middleware('permission:listar_promociones', ['only' => ['index']]);
        $this->middleware('permission:crear_promociones', ['only' => ['create','store']]);
        $this->middleware('permission:editar_promociones', ['only' => ['edit','update']]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $usuarioAuth = Auth::user();

        $promociones = Promocion::select('id', 'status', 'tipo', 'nombre', 'updated_at', 'updated_by');
        // Sin permiso solo ve la sucursal que tiene asignada
        if (!$usuarioAuth->can('ver_todas_sucursales')) {
            $promociones->whereHas('Sucursal', function ($query) use ($usuarioAuth) {
                $query->where('idsucursal', $usuarioAuth->idsucursal);
            });
        }
        $promociones->where('tipo', 2);
        
        $promociones = $promociones->get();

        return view('Promociones.noticias_list', compact('promociones'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $usuarioAuth = Auth::user();

        $sucursales = Sucursal::where('status', true)->orderBy('nombre');
        if (!$usuarioAuth->can('ver_todas_sucursales')) {
            $sucursales->where('id', $usuarioAuth->sucursal->id);
        }
        $sucursales = $sucursales->get();
        $aIdSucursalPromocion = []; // Asegúrate de definir este array

        return view('Promociones.noticias_create', compact('sucursales', 'aIdSucursalPromocion'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            if(Promocion::whereRaw("nombre ilike '$request->nombre'")->exists()){
                throw new \Exception("El nombre ya existe", 1);
            }

            $imagen_mini_name = null;
            $imagen_mini = getB64Image($request->imagen_mini);
            $img_extension = getB64Extension($request->imagen_mini);
            if(!in_array($img_extension, ['jpg', 'jpeg', 'png', 'gif'])){
                throw new \Exception("Extensión de imagen mini inválida", 1);
            }
            $imagen_mini_name = 'img_promocion'. time() . '.' . $img_extension;

            $imagen_name = null;
            if($request->imagen != ''){
                $imagen = getB64Image($request->imagen);
                $img_extension = getB64Extension($request->imagen);
                if(!in_array($img_extension, ['jpg', 'jpeg', 'png', 'gif'])){
                    throw new \Exception("Extensión de imagen inválida", 1);
                }
                $imagen_name = 'img_promocion_mini'. time() . '.' . $img_extension;
            }
            
            DB::beginTransaction();

            $oPromocion = new Promocion();
            $oPromocion->status = $request->status == 'true';
            $oPromocion->tipo = 2;
            $oPromocion->nombre = $request->nombre;
            $oPromocion->enlace = $request->enlace;
            $oPromocion->updated_by = Auth::id();
            $oPromocion->imagen_mini = $imagen_mini_name;
            $oPromocion->imagen = $imagen_name;
            $oPromocion->save();

            //Save with full path
            if($imagen_name != '')
            {
                $img_name_DB = env('APP_FOLIATTI_IMG_PATH') . 'promociones/' . $oPromocion->id . '/' .   $imagen_name;
                $oPromocion->imagen_fullpath = $img_name_DB;            
            }
            
            $img_mini_name_DB = env('APP_FOLIATTI_IMG_PATH') . 'promociones/' . $oPromocion->id . '/' .   $imagen_mini_name;
            $oPromocion->imagen_mini_fullpath = $img_mini_name_DB;            
            
            $oPromocion->save();

            foreach($request->id_sucursal as $idSucursal){
                PromocionSucursal::insert([
                    'idpromocion' => $oPromocion->id,
                    'idsucursal' => $idSucursal
                ]);
            }

            Storage::disk('promocion')->put($oPromocion->id . '/' .$imagen_mini_name, $imagen_mini);
            if($request->imagen != ''){
                Storage::disk('promocion')->put($oPromocion->id . '/' .$imagen_name, $imagen);
            }

            DB::commit();
        } catch (\Exception $e) {
            throw new InvalidRequestException($e->getMessage().$e->getLine());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $usuarioAuth = Auth::user();

        $sucursales = Sucursal::where('status', true)->orderBy('nombre')->get();

        $idSucursalUsuario = null;
        if (!$usuarioAuth->can('ver_todas_sucursales')) {
            $idSucursalUsuario = $usuarioAuth->sucursal->id;
        }

        $promocion = Promocion::findOrFail($id);

        $aIdSucursalPromocion = $promocion->sucursal()->pluck('id')->toArray();

        return view('Promociones.noticias_create', compact('sucursales', 'idSucursalUsuario', 'promocion', 'aIdSucursalPromocion'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            if(Promocion::whereRaw("nombre ilike '$request->nombre'")->where('id','<>',$id)->exists()){
                throw new \Exception("El nombre ya existe", 1);
            }

            $oPromocion = Promocion::findOrFail($id);
            
            DB::beginTransaction();
            
            $oPromocion->status = $request->status == 'true';
            $oPromocion->tipo = 2;
            $oPromocion->nombre = $request->nombre;
            $oPromocion->enlace = $request->enlace;
            $oPromocion->updated_by = Auth::id();
            $imagenDelete = [];
            $imagen_name = "";
            $imagen_mini_name = "";

            if($request->imagen_mini != ''){
                $imagenDelete[] = $oPromocion->id . '/' .$oPromocion->imagen_mini;
                $imagen_mini = getB64Image($request->imagen_mini);
                $img_extension = getB64Extension($request->imagen_mini);
                if(!in_array($img_extension, ['jpg', 'jpeg', 'png', 'gif'])){
                    throw new \Exception("Extensión de imagen mini inválida", 1);
                }
                $imagen_mini_name = 'img_promocion_mini'. time() . '.' . $img_extension;
                $oPromocion->imagen_mini = $imagen_mini_name;
                Storage::disk('promocion')->put($oPromocion->id . '/' .$imagen_mini_name, $imagen_mini);

                //Save with full path
                $img_mini_name_DB = env('APP_FOLIATTI_IMG_PATH') . 'promociones/' . $oPromocion->id . '/' .   $imagen_mini_name;
                $oPromocion->imagen_mini_fullpath = $img_mini_name_DB;            

            }

            if($request->imagen_delete != ''){
                $imagenDelete[] = $oPromocion->id . '/' .$oPromocion->imagen;
                $oPromocion->imagen = null;

                $oPromocion->imagen_fullpath = null;            

            }

            if($request->imagen != ''){
                $imagenDelete[] = $oPromocion->id . '/' .$oPromocion->imagen;
                $imagen = getB64Image($request->imagen);
                $img_extension = getB64Extension($request->imagen);
                if(!in_array($img_extension, ['jpg', 'jpeg', 'png', 'gif'])){
                    throw new \Exception("Extensión de imagen inválida", 1);
                }
                $imagen_name = 'img_promocion'. time() . '.' . $img_extension;
                $oPromocion->imagen = $imagen_name;
                Storage::disk('promocion')->put($oPromocion->id . '/' .$imagen_name, $imagen);

                //Save with full path
                $img_name_DB = env('APP_FOLIATTI_IMG_PATH') . 'promociones/' . $oPromocion->id . '/' .   $imagen_name;
                $oPromocion->imagen_fullpath = $img_name_DB;            

            }
                       
                        
            $oPromocion->save();

            if (Auth::user()->can('ver_todas_sucursales')) {
                $oPromocion->promocionSucursal()->delete();
                foreach($request->id_sucursal as $idSucursal){
                    PromocionSucursal::insert([
                        'idpromocion' => $oPromocion->id,
                        'idsucursal' => $idSucursal
                    ]);
                }
            }

            Storage::disk('promocion')->delete($imagenDelete);

            DB::commit();
        } catch (\Exception $e) {
            throw new InvalidRequestException($e->getMessage().$e->getLine());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $oBeneficio = Promocion::findOrFail($id);
        $oBeneficio->delete();
    }

}
