<?php

namespace App\Http\Controllers;

use App\Models\Estacionamiento;
use App\Models\Sucursal;
use App\Models\EstacionamientoCajon;
use Illuminate\Http\Request;
use SebastianBergmann\Environment\Console;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class EstacionamientoController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $id = Auth::id();

        $usuarioAuth = User::find($id);
        $users = User::permission('ver_todas_sucursales')->get();
        $rolAsignado = $usuarioAuth->roles()->first()->name;
        $tienePermiso = $usuarioAuth->hasPermissionTo('ver_todas_sucursales');


        if ($tienePermiso > 0) {
            /*ver todas las sucursales*/
            // $estacionamientos = Estacionamiento::all();
            $estacionamientos =  DB::table('estacionamiento')
                ->join("sucursal", "estacionamiento.idsucursal", "=", "sucursal.id")
                ->select('estacionamiento.*', 'sucursal.nombre as nombresucursal')
				//->where('estacionamiento.deleted_at', '=', 'NULL')
                ->get();
        } else {

            $estacionamientos =
                DB::table('estacionamiento')
                ->join("sucursal", "estacionamiento.idsucursal", "=", "sucursal.id")
                ->select('estacionamiento.*', 'sucursal.nombre as nombresucursal')
                ->where('sucursal.id', '=', $usuarioAuth->idsucursal)
				//->where('estacionamiento.deleted_at', '=', 'NULL')
                ->get();
        }


        return view('Estacionamiento.Estacionamiento_list', compact('estacionamientos'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //$estacionamientos = Estacionamiento::all();
        //return redirect()->route('estacionamientos', [$estacionamientos]);
        //return redirect()->route("estacionamientos.index")->with(["mensaje" => "Estacionamiento creado",]);
        $estacion = new Estacionamiento();
        $estacion->nombre = $request->nombre;
        $estacion->idsucursal = $request->idsucursal;
        $estacion->codigo = $request->codigo;
        $estacion->activo = $request->status;

        $estacion->save();

        $idEstacionamiento = $estacion->id;

        $cajon = json_decode($request->estacionamientocajon);
        if (count($cajon) > 0) {

            for ($i = 0; $i < count($cajon); $i++) {
                $activo = $cajon[$i]->activo;
                if ($activo == 1) {
                    $esActivo = true;
                } else {
                    $esActivo = false;
                }

                /*$estacioncajon = new EstacionamientoCajon();
                $estacioncajon->nombre = $cajon[$i]->nombre;
                $estacioncajon->codigo = $cajon[$i]->codigo;
                $estacioncajon->idestacionamiento = $idEstacionamiento;
                $estacioncajon->activo = $esActivo;

                $estacioncajon->save();*/

                EstacionamientoCajon::create([
                    'nombre' => $cajon[$i]->nombre,
                    'idestacionamiento' => $idEstacionamiento,
                    'activo' => $esActivo,
                    'codigo' => $cajon[$i]->codigo,
					'disponible' => true,

                ]);
            }
        }
        //return redirect()->route("Clientes.index")->with(["mensaje" => "Cliente creado",]);
        // $estacionamientos = Estacionamiento::all();
        //return redirect()->route('estacionamientos', [$estacionamientos]);
        return redirect()->route("estacionamientos.index")->with(["mensaje" => "Estacionamiento creado",]);
    }

    public function create()
    {
        //
        $id = Auth::id();

        $usuarioAuth = User::find($id);
        $users = User::permission('ver_todas_sucursales')->get();
        $rolAsignado = $usuarioAuth->roles()->first()->name;
        $tienePermiso = $usuarioAuth->hasPermissionTo('ver_todas_sucursales');

        if($tienePermiso>0){
            $sucursales = Sucursal::all();
        }else{
            $sucursales = DB::table('sucursal')            
            ->select('sucursal.*')
            ->where('sucursal.id', '=', $usuarioAuth->idsucursal)
            ->get();
        }
        



        return view('Estacionamiento.Estacionamiento_create', compact('sucursales'));
    }

    public function destroy($id)
    {
        //
        // Estacionamiento::destroy($id);

        $estacionamientos = Estacionamiento::all();

        DB::table('estacionamientocajon')->where('idestacionamiento', '=', $id)->delete();

        return view('Estacionamiento.Estacionamiento_list', compact('estacionamientos'));
    }


    public function edit($id)
    {
        //Obtener datos de la cabecera de estacionamientos
        $estacionamientos = Estacionamiento::findOrFail($id);
		$tempid = $id; 

        //obtener combo de las sucursales
        $id = Auth::id();

        $usuarioAuth = User::find($id);
        $users = User::permission('ver_todas_sucursales')->get();
        $rolAsignado = $usuarioAuth->roles()->first()->name;
        $tienePermiso = $usuarioAuth->hasPermissionTo('ver_todas_sucursales');

        if($tienePermiso>0){
            $sucursales = Sucursal::all();
        }else{
            $sucursales = DB::table('sucursal')            
            ->select('sucursal.*')
            ->where('sucursal.id', '=', $usuarioAuth->idsucursal)
            ->get();
        }
       // $sucursales = Sucursal::all();

        //Obtener datos de los detalles del estacionamiento
        $detalles =  DB::table('estacionamientocajon')->where('idestacionamiento', '=', $tempid)->get();


        return view('Estacionamiento.Estacionamiento_edit', compact('sucursales', 'estacionamientos', 'detalles'));
    }

    public function eliminarcajones($id)
    {
        EstacionamientoCajon::destroy($id);
    }

    public function actualizarcajones(Request $request)
    {
        //actualizar la cabecera
        /*$estacion = Estacionamiento::find($request->id);
        $estacion->nombre = $request->nombre;
        $estacion->idsucursal = $request->idsucursal;
        $estacion->codigo = $request->codigo;
        $estacion->activo = $request->status;
        $estacion->save();*/

        $estacion = DB::table('estacionamiento')
            ->where('id', $request->idestacionamiento)
            ->update([
                'nombre' => $request->nombre,
                'idsucursal' => $request->idsucursal,
                'codigo' => $request->codigo,
                'activo' => $request->status

            ]);


        //creación del detalle del estacionamiento
        $cajon = json_decode($request->estacionamientocajon);
        if (count($cajon) > 0) {

            for ($i = 0; $i < count($cajon); $i++) {
                $activo = $cajon[$i]->activo;
                if ($activo == 1) {
                    $esActivo = true;
                } else {
                    $esActivo = false;
                }



                EstacionamientoCajon::create([
                    'nombre' => $cajon[$i]->nombre,
                    'idestacionamiento' => $request->idestacionamiento,
                    'activo' => $esActivo,
                    'codigo' => $cajon[$i]->codigo,

                ]);
            }
        }

        //editar
        $detalle = json_decode($request->estacionamientocajoneditar);
        var_dump("detalle..", $detalle);
        if (count($detalle) > 0) {
            // error_log(print_r($detalle, TRUE)); 
            for ($i = 0; $i < count($detalle); $i++) {
                $activo = $detalle[$i]->activo;
                if ($activo == 1) {
                    $esActivo = true;
                } else {
                    $esActivo = false;
                }

                DB::table('estacionamientocajon')
                    ->where('id', $detalle[$i]->idestacionamientocajon)
                    ->update([
                        'nombre' => $detalle[$i]->nombre,
                        'idestacionamiento' => $request->idestacionamiento,
                        'activo' => $esActivo,
                        'codigo' => $detalle[$i]->codigo,

                    ]);
            }
        }




        return redirect()->route("estacionamientos.index")->with(["mensaje" => "Estacionamiento creado",]);
    }
}
