<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Repositories\ErrorRepository;
use Illuminate\Support\Facades\Response;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    public function __construct(){
        // config(['app.timezone' => setting('timezone')]);
    }

    public function sendResponse($result, $message)
    {
        return Response::json(ErrorRepository::makeResponse($message, $result));
    }

    public function sendError($error, $code = 404)
    {
        return Response::json(ErrorRepository::makeError($error), $code);
    }
}
