<?php

namespace App\Http\Controllers;

use App\Exceptions\InvalidRequestException;
use App\Models\Cliente;
use Facade\FlareClient\Http\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class ClientesController extends Controller
{


    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $clientes = Cliente::all();

        return view('Cliente.cliente_list', compact('clientes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view("Cliente.Cliente_create");
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        try {

            Cliente::create([
                'nombre' => $request->nombre,
                'apellido' => $request->apellido,
                'password' => $request->password,
                'celular' => $request->celular

            ]);
        } catch (\Exception $e) {
			
            throw new InvalidRequestException("Cliente no registrado, Telefono duplicado");
            //return redirect()->route("Clientes.index")->with(["mensaje" => "Cliente no pudo ser creado, tel�fono duplicado",]);
        }

        return redirect()->route("Clientes.index")->with(["mensaje" => "Cliente creado",]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Cliente  $cliente
     * @return \Illuminate\Http\Response
     */
    public function show(Cliente $cliente)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Cliente  $cliente
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        //        
        $cliente = Cliente::findOrFail($id);
        return view('Cliente.Cliente_edit', compact('cliente'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Cliente  $cliente
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $datosCliente = request()->except(['_token', '_method']);


        try {
            //Cliente::where('id', '=', $id)->update($datosCliente);
            DB::table('clientes')
                ->where('id', $id)
                ->update([
                    'nombre' => $request->nombre,
                    'apellido' => $request->apellido,
                    'codigo' => $request->codigo,
                    'celular' => $request->celular                                         
                ]);


            /*Actualizar la contraseña si trae datos el campo */
            if (empty(!$request->password)) {
                DB::table('clientes')
                    ->where('id', $id)
                    ->update([
                        'password' => Hash::make($request->password),
                    ]);
            }



            $cliente = Cliente::findOrFail($id);  
            $clientes = Cliente::all();


        } catch (\Exception $e) {

            throw new InvalidRequestException($e->getMessage());
        }

        return view('Cliente.cliente_list', compact('clientes'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Cliente  $cliente
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        //Cliente::destroy($id);

        $clientes = Cliente::all();

        return view('Cliente.Cliente_list', compact('clientes'));
    }
}
