<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Vehiculo;
use App\Models\VehiculoHistorial;
use App\Models\VehiculoValet;
use App\Models\Iticket;
use App\Repositories\VehiculoHistorialRepository;
use App\Repositories\VehiculoRepository;
use App\Repositories\VehiculoValetRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Prettus\Validator\Exceptions\ValidatorException;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;

class VehiculoAPIController extends Controller
{
    private $vehiculoRepository;
    private $vehiculoValetRepository;
    private $vehiculoHistorialRepository;
	private $iticketRepository;


    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(VehiculoRepository $vehiculoRepository, VehiculoValetRepository $vehiculoValetRepository, VehiculoHistorialRepository $vehiculoHistorialRepository)
    {
        $this->vehiculoRepository = $vehiculoRepository;
        $this->vehiculoValetRepository = $vehiculoValetRepository;
        $this->vehiculoHistorialRepository = $vehiculoHistorialRepository;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $this->validate($request, [
            'placas' => 'required',

        ]);
        try {
            $vehiculo = $this->vehiculoRepository->create(array(
                'placas' => $request->placas,
            ));
            $this->vehiculoHistorialRepository->create(array(
                'idvehiculo' => $vehiculo->id,
                'placas' => $request->placas,
            ));

        } catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($vehiculo->toArray(), 'Vehiculo agregado correctamente');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function show(Vehiculo $vehiculo)
    {
        //
    }


    public function getVehiculo($placas){
        $vehiculo = Vehiculo::where('placas',$placas)->leftjoin('marca', 'marca.id', '=' , 'vehiculos.idmarca')
                                                    ->leftjoin('linea', 'linea.id', '=' , 'vehiculos.idlinea')
                                                    ->leftjoin('color', 'color.id', '=' , 'vehiculos.idcolor')
                                                    ->leftjoin('iticket', 'iticket.idvehiculo', 'vehiculos.id')
                                                    ->leftjoin('estacionamientocajon', 'iticket.idestacionamientocajon', 'estacionamientocajon.id')
                                                    ->leftjoin('estacionamiento', 'estacionamientocajon.idestacionamiento', 'estacionamiento.id')
                                                    //idestacionamientocajon
                                                    //idestacionamiento
                                                    ->select('vehiculos.*', 'estacionamiento.nombre as NombreEstacionamiento', 'estacionamientocajon.nombre as NombreEstacionamientoCajon', 'estacionamientocajon.idestacionamiento',  'iticket.idestacionamientocajon','iticket.img_1', 'iticket.img_2', 'iticket.img_3', 'iticket.img_4', 'iticket.img_5', 'iticket.img_6','marca.nombre as NombreMarca', 'linea.nombre as NombreLinea', 'color.nombre as NombreColor')->get();
    
        if (empty($vehiculo)) {
            return $this->sendError(utf8_encode('Vehículo no encontrado'));
        }else {
            return $this->sendResponse($vehiculo, utf8_encode('Vehículo encontrado'));
        }   
    }

    

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function edit(Vehiculo $vehiculo)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $idvehiculo)
    {
        $this->validate($request, [
            'idcompany' => 'nullable',
            'idsucursal' => 'nullable',
            'idmarca' => 'nullable',
            'idlinea' => 'nullable',
            'idcolor' => 'nullable',
            'modelo' => 'nullable',
            'observaciones' => 'nullable',
            'img_frente' => 'nullable',
            'img_izq' => 'nullable',
            'img_der' => 'nullable',
            'img_atras' => 'nullable',
            'img_extra1' => 'nullable',
            'img_extra2' => 'nullable',
        ]);

        if(($request->idmarca == null) || ($request->idlinea == null) || ($request->idcolor == null) || ($request->modelo == null) 
        //|| ($request->idmarca == null) || ($request->idmarca == null)
        )
        {
            return $this->sendError("Se requiere marca, línea, modelo y color", '401');
        }

		$definedDisk = "vehiculosplacas";
		$imagesPath = "vehiculos/placas/" . $idvehiculo . "/";

        try {

            $img_frente = $request->img_frente;
			if($img_frente != null)
			{
				try
				{
					$img_frente = getB64Image($img_frente);
					$img_extension = getB64Extension($request->img_frente);
					$img_name_frente = 'img_frente_'. time() . '.' . $img_extension;
					Storage::disk($definedDisk)->put($idvehiculo . '/' . $img_name_frente, $img_frente);
				}
				catch (Exception $eimage)
				{
				}
			}
			else
			{
				$img_frente = "";
				$img_name_frente = "";
			}

		    $img_izq = $request->img_izq;
			if($img_izq != null)
			{
				try
				{					
					$img_izq = getB64Image($img_izq);
					$img_extension = getB64Extension($request->img_izq);
					$img_name_izq = 'img_izq_'. time() . '.' . $img_extension;
					Storage::disk('vehiculosplacas')->put($idvehiculo . '/' .$img_name_izq, $img_izq);
				}
				catch (Exception $eimage)
				{
				}
			}
			else
			{
				$img_izq = "";
				$img_name_izq = "";
			}

			$img_der = $request->img_der;
			if($img_der != null)
			{
				try
				{

					$img_der = getB64Image($img_der);
					$img_extension = getB64Extension($request->img_der);
					$img_name_der = 'img_der_'. time() . '.' . $img_extension;
					Storage::disk('vehiculosplacas')->put($idvehiculo . '/' .$img_name_der, $img_der);
				}
				catch (Exception $eimage)
				{
				}
			}
			else
			{
				$img_der = "";
				$img_name_der = "";
			}

			$img_atras = $request->img_atras;
			if($img_atras != null)
			{
				try
				{			
					
					$img_atras = getB64Image($img_atras);
					$img_extension = getB64Extension($request->img_atras);
					$img_name_atras = 'img_atras_'. time() . '.' . $img_extension;
					Storage::disk('vehiculosplacas')->put($idvehiculo . '/' .$img_name_atras, $img_atras);
				}
				catch (Exception $eimage)
				{
				}
			}
			else
			{
				$img_atras = "";
				$img_name_atras = "";
			}


//Imagen 5
			$img_extra1 = $request->img_extra1;
			if($img_extra1 != null)
			{
				try
				{			
					
					$img_extra1 = getB64Image($img_extra1);
					$img_extension = getB64Extension($request->img_extra1);
					$img_name_extra1 = 'img_extra1_'. time() . '.' . $img_extension;
					Storage::disk('vehiculosplacas')->put($idvehiculo . '/' .$img_name_extra1, $img_extra1);
				}
				catch (Exception $eimage)
				{
				}
			}
			else
			{
				$img_extra1 = "";
				$img_name_extra1 = $request->img_extra1;
			}

//Imagen 6
			$img_extra2 = $request->img_extra2;
			if($img_extra2 != null)
			{
				try
				{			
					
					$img_extra2 = getB64Image($img_extra2);
					$img_extension = getB64Extension($request->img_extra2);
					$img_name_extra2 = 'img_extra2_'. time() . '.' . $img_extension;
					Storage::disk('vehiculosplacas')->put($idvehiculo . '/' .$img_name_extra2, $img_extra2);
				}
				catch (Exception $eimage)
				{
				}
			}
			else
			{
				$img_extra2 = "";
				$img_name_extra2 = $request->img_extra2;
			}



			$observacionesv = $request->observaciones;
			if($observacionesv == null)
			{
				$observacionesv = "";
			}




            $vehiculo = $this->vehiculoRepository->update(array(
                'idcompany' => $request->idcompany,
                'idsucursal' => $request->idsucursal,
                'idmarca' => $request->idmarca,
                'idlinea' => $request->idlinea,
                'idcolor' => $request->idcolor,
                'modelo' => $request->modelo,
                'observaciones' => $observacionesv,
                'img_frente' => $img_name_frente,
                'img_izq' => $img_name_izq,
                'img_der' => $img_name_der,
                'img_atras' => $img_name_atras,
            ), $idvehiculo);

            $vehiculoHistorial = VehiculoHistorial::where('idvehiculo', $idvehiculo)->first();
            $vehiculoHistorial->idcompany = $request->idcompany;
            $vehiculoHistorial->idsucursal = $request->idsucursal;
            $vehiculoHistorial->idmarca = $request->idmarca;
            $vehiculoHistorial->idlinea = $request->idlinea;
            $vehiculoHistorial->idcolor = $request->idcolor;
            $vehiculoHistorial->modelo = $request->modelo;
            $vehiculoHistorial->observaciones = $request->observaciones;
            $vehiculoHistorial->img_frente = $img_name_frente;
            $vehiculoHistorial->img_izq = $img_name_izq;
            $vehiculoHistorial->img_der = $img_name_der;
            $vehiculoHistorial->img_atras = $img_name_atras;
            $vehiculoHistorial->save();

			//Actualizando data de fotos en el iditicket
			$iticketGotten = $iticket = Iticket::where('idvehiculo', $idvehiculo)
            ->orderBy('id', 'desc')
            ->first();

            $iticketGotten->objetosvalor = $observacionesv;
            $iticketGotten->img_1 = (($img_name_frente != null) && ($img_name_frente != ""))?env('APP_FOLIATTI_IMG_PATH') . $imagesPath . $img_name_frente:null;//
            $iticketGotten->img_2 = (($img_name_izq != null) && ($img_name_izq != ""))?env('APP_FOLIATTI_IMG_PATH') . $imagesPath . $img_name_izq:null;//$imagesPath . $img_name_izq;
            $iticketGotten->img_3 = (($img_name_der != null) && ($img_name_der != ""))?env('APP_FOLIATTI_IMG_PATH') . $imagesPath . $img_name_der:null;//$imagesPath . $img_name_der;
            $iticketGotten->img_4 = (($img_name_atras != null) && ($img_name_atras != ""))?env('APP_FOLIATTI_IMG_PATH') . $imagesPath . $img_name_atras:null;//$imagesPath . $img_name_atras;
			$iticketGotten->img_5 = (($img_name_extra1 != null) && ($img_name_extra1 != ""))?env('APP_FOLIATTI_IMG_PATH') . $imagesPath . $img_name_extra1:null;//$imagesPath . $img_name_extra1;
			$iticketGotten->img_6 = (($img_name_extra2 != null) && ($img_name_extra2 != ""))?env('APP_FOLIATTI_IMG_PATH') . $imagesPath . $img_name_extra2:null;//$imagesPath . $img_name_extra2;

            $iticketGotten->save();



            

        } catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($vehiculo->toArray(), utf8_encode('Vehículo actualizado correctamente'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function destroy(Vehiculo $vehiculo)
    {
        //
    }
}
