<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Turno;
use App\Repositories\TurnoRepository;
use App\Repositories\UserRepository;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Prettus\Validator\Exceptions\ValidatorException;

class TurnoAPIController extends Controller
{
    private $turnoRepository;
    private $userRepository;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(TurnoRepository $turnoRepository, UserRepository $userRepository)
    {
        $this->turnoRepository = $turnoRepository;
        $this->userRepository = $userRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    public function abrirTurno($id){
        try{
            //$user = $this->userRepository->findWithoutFail($id);
            $user = User::where('id', $id)->firstOrFail();

            if(!empty($user)){
                $turno = Turno::where('idempleado', $id)->first();
                if($turno == NULL){
                    $turno = $this->turnoRepository->create(array(
                        'idempleado' => $user->id,
                        'nombre' => $user->nombre,
                        'fecha_inicio' => Carbon::now(),
                        'fecha_fin' => NULL,
                        'activo' => 1,
                    ));
                }else {
                    $turno = $this->turnoRepository->update(array(
                        'idempleado' => $user->id,
                        'fecha_inicio' => Carbon::now(),
                        'fecha_fin' => NULL,
                        'activo' => 1,
                    ), $turno->id);
                }  
            } else {
                return $this->sendError('No existe el empleado');
            }
        }catch (\Exception $e){
            return $this->sendError('Error en la verificacion de datos');
        }
        return $this->sendResponse($turno->toArray(), 'Registrado correctamente');
    }

    public function cerrarTurno($id){
        try{
            //$user = $this->userRepository->findWithoutFail($id);
            $user = User::where('id', $id)->firstOrFail();
            if(!empty($user)){
                $turno = Turno::where('idempleado', $id)->first();
                if($turno == NULL){
                    $turno = $this->turnoRepository->create(array(
                        'idempleado' => $user->id,
                        'nombre' => $user->nombre,
                        'fecha_inicio' => NULL,
                        'fecha_fin' => Carbon::now(),
                        'activo' => 0,
                    ));
                }else {
                    $turno = $this->turnoRepository->update(array(
                        'idempleado' => $user->id,
                        'fecha_inicio' => NULL,
                        'fecha_fin' => Carbon::now(),
                        'activo' => 0,
                    ), $turno->id);
                }  
            } else {
                return $this->sendError('No existe el empleado');
            }
        }catch (\Exception $e){
            return $this->sendError('Error en la verificacion de datos');
        }
        return $this->sendResponse($turno->toArray(), 'Registrado correctamente');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        //
    }
}