<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\TipoIdentificacion;
use App\Repositories\TipoIdentificacionRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Tools;

class TipoIdentificacionAPIController extends Controller
{
    private $tipoIdentificacionRepository;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(TipoIdentificacionRepository $tipoIdentificacionRepository)
    {
        $this->tipoIdentificacionRepository = $tipoIdentificacionRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

		$this->validate($request, [
            'nombre' => 'required',

        ]);

        try {
            $marca = $this->colorRepository->create(array(
                'nombre' => $request->nombre,
				'activo' => true,
				'codigo' => '1',

            ));


		} catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($marca->toArray(), 'Pais Civil agregado correctamente');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function show(Pais $pais)
    {
        //
    }


    public function getTiposIdentificacion(){
        $tiposIdentificacion = $this->tipoIdentificacionRepository->all();

        if ($tiposIdentificacion->isEmpty()) {
            return $this->sendError('Lista de Tipos de Identificacion vacia');
        } else {
            return $this->sendResponse($tiposIdentificacion, 401);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function edit(TiposIdentificacion $tiposIdentificacion)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\color  $color
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function destroy(TiposIdentificacion $tiposIdentificacion)
    {
        //
    }

    public function synchronizeTiposIdentificacion()
    {

        $url = env('APP_FOLIATTIAPI_URL') . "Catalogs/getTiposIdentificacion";
		$method="GET";
		$output = (new Tools)->CallAPI($method, $url);
		$result = json_decode($output);
        
        $tiposIdentificacion = $result->tipos_identificacion;
        if($estados != null)
        {

            foreach ($estados as &$estado) 
            {
                try
                {
                    $estadoToInsert = new Estado;
                    $estadoToInsert->id = $estado->id;
                    $estadoToInsert->idpais = $estado->id_pais;
                    $estadoToInsert->nombre = $estado->nombre;
                    $estadoToInsert->codigo = $estado->codigo;
                    $estadoToInsert->activo = true;
                    $estadoToInsert->save();
                }
			    catch(\Exception $excep)
		    	{
                    return $this->sendError($excep->getMessage(), 404);
   
                }



            }
        }


        return $this->sendResponse($result->estados[0]->id . $result->estados[0]->nombre, 401);

    }

}