<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Pais;
use App\Repositories\PaisRepository;
use Illuminate\Http\Request;

use App\Http\Controllers\Tools;


class PaisAPIController extends Controller
{
    private $paisRepository;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(PaisRepository $paisRepository)
    {
        $this->paisRepository = $paisRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

		$this->validate($request, [
            'nombre' => 'required',

        ]);

        try {
            $marca = $this->colorRepository->create(array(
                'nombre' => $request->nombre,
				'activo' => true,
				'codigo' => '1',

            ));


		} catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($marca->toArray(), 'Pais Civil agregado correctamente');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function show(Pais $pais)
    {
        //
    }


    public function synchronizePaises()
    {
        $url = env('APP_FOLIATTIAPI_URL') . "Catalogs/getPaises";
		$method="GET";
		$output = (new Tools)->CallAPI($method, $url);
		$result = json_decode($output);
        
        $paises = $result->paises;
        if($paises != null)
        {

            foreach ($paises as &$pais) 
            {
                try
                {
                    $paisToInsert = new Pais;
                    $paisToInsert->id = $pais->id;
                    $paisToInsert->nombre = $pais->nombre;
                    $paisToInsert->codigo = $pais->codigo;
                    $paisToInsert->activo = true;
                    $paisToInsert->save();
                }
			    catch(\Exception $excep)
		    	{
                    return $this->sendError($excep->getMessage(), 404);
   
                }



            }
        }


        return $this->sendResponse($result->paises[0]->id . $result->paises[0]->nombre . $result->paises[0]->codigo, 401);

    }


    public function getPaises(){
        $paises = $this->paisRepository->orderBy("nombre", "asc")->all();

        if ($paises->isEmpty()) {
            return $this->sendError('Lista de Países vacia');
        } else {
            return $this->sendResponse($paises, 401);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function edit(Pais $pais)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\color  $color
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function destroy(Pais $pais)
    {
        //
    }
}
