<?php
namespace App\Http\Controllers\API;

//require 'vendor/autoload.php'; // Asegúrate de tener las dependencias de Google API instaladas via Composer

require base_path('vendor/autoload.php');

use Google\Auth\OAuth2;
use Google\Auth\HttpHandler\HttpHandlerFactory;
use GuzzleHttp\Client;

use App\Http\Controllers\Controller;

use App\Models\Promocion;
use App\Models\PromocionNotificacion;
use App\Models\Cliente;
use App\Repositories\PromocionRepository;

use App\Models\ClienteSucursal;
use App\Repositories\ClienteRepository;

use Illuminate\Http\Request;
use App\Http\Controllers\Tools;
use DB;
use Illuminate\Support\Collection;
use Illuminate\Support\Carbon;

class NotificacionesAPIController extends Controller
{

    private $clienteRepository;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(ClienteRepository $clienteRepository)
    {
        $this->clienteRepository = $clienteRepository;
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function show(Beneficio $beneficio)
    {
        //
    }

    public function enviarNotificacionCliente(Request $request)
    {
        try {
            /*
            $this->validate($request, [
                'appId' => 'required',
                'encabezado' =>'required',
                'mensaje' => 'required',
            ]);
            */
            
            $cliente = Cliente::find($request->input('appId'));

            $titulo = $request->input('encabezado');
            $mensaje = $request->input('mensaje');

            if($cliente != null)
            {
                if($cliente->firebase_token != "")
                {
                    // Ruta al archivo JSON de la cuenta de servicio en storage/app/firebase
                    $serviceAccountFile = storage_path('app/firebase/foliatti-85cb9-firebase-adminsdk-qx5ak-6913c5c0a3.json');


                    // Verifica si el archivo existe
                    if (!file_exists($serviceAccountFile)) 
                    {
                        die('El archivo de la cuenta de servicio no se encontró en la ruta especificada.');
                    }

                    // Cargar el contenido del archivo JSON
                    $serviceAccountContent = file_get_contents($serviceAccountFile);

                    if ($serviceAccountContent === false) {
                        die('No se pudo leer el archivo de la cuenta de servicio.');
                    }

                    // Decodificar el contenido JSON
                    $serviceAccountData = json_decode($serviceAccountContent, true);

                    if (json_last_error() !== JSON_ERROR_NONE) {
                        die('El archivo de la cuenta de servicio no contiene un JSON válido.');
                    }

                    // Crear un OAuth2 instance con el algoritmo de firma especificado
                    $oauth2 = new OAuth2([
                        'audience' => 'https://oauth2.googleapis.com/token',
                        'issuer' => $serviceAccountData['client_email'],
                        'signingKey' => $serviceAccountData['private_key'],
                        'signingAlgorithm' => 'RS256',
                        'tokenCredentialUri' => 'https://oauth2.googleapis.com/token',
                        'scope' => 'https://www.googleapis.com/auth/firebase.messaging',

                    ]);

                    try
                    {
                        $authToken = $oauth2->fetchAuthToken(HttpHandlerFactory::build());
                    } catch (\Exception $e) 
                    {
                            //echo $e;
                    }

                    //echo "linea 64<hr>";

                    // Verifica si se obtuvo un token de acceso
                    if (!isset($authToken['access_token'])) 
                    {
                    //echo "No se pudo obttener un token de acceso";
                    die('No se pudo obtener un token de acceso.');
                    }

                    //echo "linea 69<hr>";

                    // Extraer el token de acceso
                    $accessToken = $authToken['access_token'];

                    //echo "linea 74<hr>";

                    //echo "Access Token: $accessToken\n <hr>";

                    // Continuación del código para enviar la notificación push a Firebase...

                    $recipient_device_token = 
                    //'eVbZ07ScSYayLgpA6NCMdT:APA91bHlc7pJtOt-gzEvpjeQzX_NmfVCnjCQIZFEM4tpGNmATlBYK3b00lBK7kdNLHuLtCPSDtAM_Bhqi7lv7B6Uejw1mEAllTnrLKnBieTPExph7O_9Gmypib0MJF_rOsi2-TSXpgnq';
                    //'cKNIhROKhETulnVJKBvBYE:APA91bFLAFpD7FhJ6mB2N5AmzldfplzLOAftoSbUwHQ6rafbp3PygLeR_jGwshFUdcv7xgBrXHiuVn1O7kM6FajJYRdzNygG6TMGxhubj5N86KUkGH0HXsWkl4RZfMdlUxTpixjefTPo';
                    $cliente->firebase_token;

                    $notification = [
                        'message' => [
                            'token' => $recipient_device_token, // Token del dispositivo receptor
                            'notification' => [
                                'title' => $titulo, //mb_convert_encoding($titulo, 'UTF-8', 'auto'),
                                'body' => $mensaje, //mb_convert_encoding($mensaje, 'UTF-8', 'auto'),
                            ],
                        ],
                    ];

                    //echo "linea 183\n";

                    // Verifica que los datos JSON estén correctamente codificados en UTF-8
                    $jsonNotification = json_encode($notification);
                    

                    //echo "linea 189\n";

                    if (json_last_error() !== JSON_ERROR_NONE) {
                        die('Error al codificar JSON: ' . json_last_error_msg());
                    }

                    try
                    {

                    //echo "linea 198";
                    // Crear cliente Guzzle
                    $client = new Client();

                    //echo "linea 201";

                    try {
                        // Realizar la llamada a Firebase
                        $response = $client->post('https://fcm.googleapis.com/v1/projects/foliatti-85cb9/messages:send', [
                            'headers' => [
                                'Authorization' => "Bearer $accessToken",
                                'Accept' => 'application/json',
                                'Content-Type' => 'application/json',
                            ],
                            'body' => $jsonNotification,
                        ]);

                    //echo "linea 215 - after response <hr>";

                        // Mostrar la respuesta
                        //echo $response->getBody()->getContents();

                    } catch (Exception $e) {
                        //echo "si hubo errores";
                        //echo 'Request Exception: ' . $e->getMessage();
                        if ($e->hasResponse()) 
                        {
                            //echo ' Response: ' . $e->getResponse()->getBody()->getContents();
                        }


                    }
                    finally {

                        if($response == null)
                        {
                            //echo "response is null";
                            return $this->sendError('El usuario no está correctamente registrado para recepción de notificaciones - 01', 401);
                        }
                        else
                        {
                            //echo "is not null";
                        }
                        // Code that is always executed
                    }



                    //echo "linea 132\n";

                    }catch(\Exception $e2)
                    {
                        //echo "linea 247";
                        //echo $e2;
                        return $this->sendError('El usuario no está correctamente registrado para recepción de notificaciones - 02', 401);    
                    }

                }
                else //El usuario no tiene firebase_token
                {
                    return $this->sendError('El usuario no está registrado para recepción de notificaciones', 400);

                }

            }
            else
            {
                //echo "cliente no existe";
                return $this->sendError('El usuario no se encuentra registrado', 500);
            }
        } catch (\Exception $e) {
            return $this->sendError($e . 'appId o mensaje incorrectos', 500);
        }

            //return $this->sendError('Envío realizado', 200);
            return $this->sendResponse('Notificación realizada correctamente', 200);
            //return $this->sendResponse($promociones, 401);
    }    





    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function edit(EstadoCivil $estadoCivil)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\color  $color
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function destroy(EstadoCivil $estadoCivil)
    {
        //
    }


}
