<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Municipio;
use App\Repositories\MunicipioRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Tools;

class MunicipioAPIController extends Controller
{
    private $municipioRepository;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(MunicipioRepository $municipioRepository)
    {
        $this->municipioRepository = $municipioRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

		$this->validate($request, [
            'nombre' => 'required',

        ]);

        try {
            $marca = $this->colorRepository->create(array(
                'nombre' => $request->nombre,
				'activo' => true,
				'codigo' => '1',

            ));


		} catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($marca->toArray(), 'Estado Civil agregado correctamente');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function show(Municipio $municipio)
    {
        //
    }


    public function getMunicipios(){
        $municipios = $this->municipioRepository->all();

        if ($municipios->isEmpty()) {
            return $this->sendError('Lista de Municipios vacia');
        } else {
            return $this->sendResponse($municipios, 401);
        }
    }

    public function getMunicipiosByidestado($idestado){
        $municipios = Municipio::where('idestado', $idestado)
        ->orderBy("nombre", "asc")
        ->get();


        if ($municipios->isEmpty()) {
            return $this->sendError('Lista de Municipios vacia');
        } else {
            return $this->sendResponse($municipios, 401);
        }
    }

    public function getMunicipioByid($idmunicipio){
        $municipios = Municipio::where('id', $idmunicipio)->get();


        if ($municipios->isEmpty()) {
            return $this->sendError('Lista de Municipios vacia');
        } else {
            return $this->sendResponse($municipios, 401);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function edit(Municipio $municipio)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\color  $color
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function destroy(Municipio $municipio)
    {
        //
    }

    public function synchronizeMunicipios()
    {

        $url = env('APP_FOLIATTIAPI_URL') . "Catalogs/getMunicipios";
		$method="GET";
		$output = (new Tools)->CallAPI($method, $url);
		$result = json_decode($output);
        
        $municipios = $result->municipios;
        if($municipios != null)
        {

            foreach ($municipios as &$municipio) 
            {
                try
                {
                    $municipioToInsert = new Municipio;
                    $municipioToInsert->id = $municipio->id;
                    $municipioToInsert->idestado = $municipio->id_estado;
                    $municipioToInsert->nombre = $municipio->nombre;
                    $municipioToInsert->codigo = $municipio->id;
                    $municipioToInsert->activo = true;
                    $municipioToInsert->save();
                }
			    catch(\Exception $excep)
		    	{
                    return $this->sendError($excep->getMessage(), 404);
   
                }



            }
        }


        return $this->sendResponse($result->municipios[0]->id . $result->municipios[0]->nombre . $result->municipios[0]->id, 401);

    }

}
