<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Genero;
use App\Repositories\GeneroRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Tools;

class GeneroAPIController extends Controller
{
    private $generoRepository;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(GeneroRepository $generoRepository)
    {
        $this->generoRepository = $generoRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

		$this->validate($request, [
            'nombre' => 'required',

        ]);

        try {
            $marca = $this->colorRepository->create(array(
                'nombre' => $request->nombre,
				'activo' => true,
				'codigo' => '1',

            ));


		} catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($marca->toArray(), 'Estado Civil agregado correctamente');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function show(Genero $genero)
    {
        //
    }


    public function getGeneros(){
        $generos = $this->generoRepository->all();

        if ($generos->isEmpty()) {
            return $this->sendError('Lista de G�neros vacia');
        } else {
            return $this->sendResponse($generos, 401);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function edit(Genero $genero)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\color  $color
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function destroy(Genero $genero)
    {
        //
    }


    public function synchronizeGeneros()
    {

        $url = env('APP_FOLIATTIAPI_URL') . "Catalogs/getGeneros";
		$method="GET";
		$output = (new Tools)->CallAPI($method, $url);
		$result = json_decode($output);
        
        $generos = $result->generos;
        if($generos != null)
        {

            foreach ($generos as &$genero) 
            {
                try
                {
                    $generoToInsert = new Genero;
                    $generoToInsert->id = $genero->id;
                    $generoToInsert->nombre = $genero->nombre;
                    $generoToInsert->activo = true;
                    $generoToInsert->save();
                }
			    catch(\Exception $excep)
		    	{
                    return $this->sendError($excep->getMessage(), 404);
   
                }



            }
        }


        return $this->sendResponse($result->generos[0]->id . $result->generos[0]->nombre, 401);

    }

}
