<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\EstadoCivil;
use App\Repositories\EstadoCivilRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Tools;

class EstadoCivilAPIController extends Controller
{
    private $estadoCivilRepository;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(EstadoCivilRepository $estadoCivilRepository)
    {
        $this->estadoCivilRepository = $estadoCivilRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

		$this->validate($request, [
            'nombre' => 'required',

        ]);

        try {
            $marca = $this->colorRepository->create(array(
                'nombre' => $request->nombre,
				'activo' => true,
				'codigo' => '1',

            ));


		} catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($marca->toArray(), 'Estado Civil agregado correctamente');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function show(EstadoCivil $estadoCivil)
    {
        //
    }


    public function getEstadosCiviles(){
        $estadosCiviles = $this->estadoCivilRepository->all();

        if ($estadosCiviles->isEmpty()) {
            return $this->sendError('Lista de Estados Civiles vacia');
        } else {
            return $this->sendResponse($estadosCiviles, 401);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function edit(EstadoCivil $estadoCivil)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\color  $color
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function destroy(EstadoCivil $estadoCivil)
    {
        //
    }


    public function synchronizeEstadosCiviles()
    {

        $url = env('APP_FOLIATTIAPI_URL') . "Catalogs/getEstadosCiviles";
		$method="GET";
		$output = (new Tools)->CallAPI($method, $url);
		$result = json_decode($output);
        
        $estados = $result->estados_civiles;
        if($estados != null)
        {

            foreach ($estados as &$estado) 
            {
                try
                {
                    $estadoToInsert = new EstadoCivil;
                    $estadoToInsert->id = $estado->id;
                    $estadoToInsert->nombre = $estado->nombre;
                    $estadoToInsert->activo = true;
                    $estadoToInsert->save();
                }
			    catch(\Exception $excep)
		    	{
                    return $this->sendError($excep->getMessage(), 404);
   
                }



            }
        }


        return $this->sendResponse($result->estados[0]->id . $result->estados[0]->nombre, 401);

    }
}
