<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\EstacionamientoCajon;
use App\Repositories\EstacionamientoCajonRepository;
use App\Models\Estacionamiento;
use App\Repositories\EstacionamientoRepository;
use Illuminate\Http\Request;

class EstacionamientoCajonAPIController extends Controller
{
    private $estacionamientocajonRepository;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(EstacionamientoCajonRepository $estacionamientocajonRepository)
    {
        $this->estacionamientocajonRepository = $estacionamientocajonRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
        //
    }


    public function getEstacionamientocajon($idestacionamiento){
        $estacionamientocajon = EstacionamientoCajon::where('idestacionamiento', $idestacionamiento)->join('estacionamiento', 'estacionamiento.id', '=' , 'estacionamientocajon.idestacionamiento')
                                                                            ->select('estacionamientocajon.*', 'estacionamiento.nombre as NombreEstacionamiento')
                                                                            ->where('estacionamientocajon.activo', '=', true)
                                                                            ->where('estacionamientocajon.disponible', '=', true)
                                                                            ->orderBy("estacionamientocajon.id", "asc")
                                                                            ->get();

        if(empty($estacionamientocajon)){
            return $this->sendError('No hay cajon asignados a este estacionamiento');
        }else {
            return $this->sendResponse($estacionamientocajon, 'Lista de cajones de este estacionamiento');
        }   

    }

    public function getAllEstacionamientocajon($idsucursal){
        $estacionamientocajon = Estacionamiento::where('idsucursal', $idsucursal)->join('estacionamientocajon', 'estacionamientocajon.idestacionamiento', '=', 'estacionamiento.id')->where('estacionamientocajon.disponible', '=', true)->get();


        if(empty($estacionamientocajon)){
            return $this->sendError('No hay cajon asignados a este estacionamiento');
        }else {
            return $this->sendResponse($estacionamientocajon->count(), 'Total de estacionamientos disponibles');
        }   
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function destroy()
    {
        //
    }
}
