<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Cliente;
use App\Models\ClienteSucursal;
use App\Repositories\ClienteRepository;
use Facade\FlareClient\Http\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use DB;
use Yajra\Datatables\Datatables;

use App\Http\Controllers\Tools;
use App\Models\Promocion;
use Illuminate\Support\Facades\Storage;
use function PHPUnit\Framework\isEmpty;

class ClienteAPIController extends Controller
{

    private $clienteRepository;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(ClienteRepository $clienteRepository)
    {
        $this->clienteRepository = $clienteRepository;
    }

    function login(Request $request)
    {
        try {
            $this->validate($request, [
                'celular' => 'required',
                'password' => 'required',
            ]);
            if (Auth::guard('clientes')->attempt(['celular' => $request->input('celular'), 'password' => $request->input('password')])) {
                // Authentication passed...
                $cliente = Auth::guard('clientes')->user();
                if($cliente->status)
                {
                    $cliente->device_token = $request->input('device_token', '');
                    $cliente->save();
                    return $this->sendResponse($cliente, 'Conexion exitosa');
                }
                else
                {
                    return $this->sendError('El usuario aún no ha verificado su cuenta', 402);
                }
            } else {
                return $this->sendError('Telefono y/o contraseña incorrectos', 401);
            }
        } catch (\Exception $e) {
            return $this->sendError('Telefono y/o contraseña incorrectos', 401);
        }

    }
    
    function register(Request $request)
    {
        try {
            $this->validate($request, [
                'celular' => 'required|unique:clientes',
                'password' => 'required',
                //'AppSignature' => 'required'
            ]);

			try
			{
	            $appSignature = $request->input('AppSignature');
			}
			catch(\Exception $excep)
			{
	            $appSignature = "";
			}

            $codigo = mt_rand(100000, 999999);
            $cliente = new Cliente;
            $cliente->codigo = $codigo;
            $cliente->celular = $request->input('celular');
            $cliente->password = Hash::make($request->input('password'));
            $cliente->device_token = $request->input('device_token', '');
            $cliente->api_token = Str::random(60);
            
            $url = "https://apps.ecdevelopment.mx/SmsEngine/Services/SmsEngine.svc/SMSRequest";
            $response = Http::post($url, [
                "security" => [
                    "AppId" => 6,
                    "Time" => "1634093106",
                    "Hash" => "41d7c1734734ff80b12d02a3a961af51"
                ],
                    "message" => [
                        "SiteId" => "SMS",
                        "Cellphone" => $request->input('celular'),
                        "Message"=> "Tu codigo de verificacion es: $codigo $appSignature"
                        ]
            ]);
            $cliente->save();
        } catch (\Exception $e) {
            //Log::error($e->getMessage());
            return $this->sendError($e->getMessage(), 401);
        }


        return $this->sendResponse($cliente, 'Cliente registrado exitosamente');
    }

    function registerWithEmail(Request $request)
    {
        try {
            $this->validate($request, [
                'celular' => 'required|unique:clientes',
                'password' => 'required',
                'email' => 'required', /*|unique:clientes*/

                //'AppSignature' => 'required'
            ]);

			try
			{
	            $appSignature = $request->input('AppSignature');
			}
			catch(\Exception $excep)
			{
	            $appSignature = "";
			}

            $codigo = mt_rand(100000, 999999);
            $cliente = new Cliente;
            $cliente->codigo = $codigo;
            $cliente->celular = $request->input('celular');
            $cliente->email = $request->input('email');

            $cliente->password = Hash::make($request->input('password'));
            $cliente->device_token = $request->input('device_token', '');
            $cliente->api_token = Str::random(60);
            
            $url = "https://apps.ecdevelopment.mx/SmsEngine/Services/SmsEngine.svc/SMSRequest";
            $response = Http::post($url, [
                "security" => [
                    "AppId" => 6,
                    "Time" => "1634093106",
                    "Hash" => "41d7c1734734ff80b12d02a3a961af51"
                ],
                    "message" => [
                        "SiteId" => "SMS",
                        "Cellphone" => $request->input('celular'),
                        "Message"=> "Tu codigo de verificacion es: $codigo $appSignature"
                        ]
            ]);
            $cliente->save();
        } catch (\Exception $e) {
            //Log::error($e->getMessage());
			
            return $this->sendError("No es posible registrarse con la información proporcionada.", 401);
        }


        return $this->sendResponse($cliente, 'Cliente registrado exitosamente');
    }


    function getRegistroClienteFoliatti(Request $request, $id)
	{
        $url = env('APP_FOLIATTIAPI_URL');
        if($url == null)
        {
            return $this->sendError("this ir the url:" . $url, 401);
        }

		$url = env('APP_FOLIATTIAPI_URL') . "Player/getPreRegistroByAppId?AppId=" . $id;//Catalogs/getPaises
		$method="GET";
		$output = (new Tools)->CallAPI($method, $url);



		$result = json_decode($output);
		
		return $result;	
	}

    function getCuentaClienteFoliatti(Request $request, $id)
	{
        $url = env('APP_FOLIATTIAPI_URL');
        if($url == null)
        {
            return $this->sendError("this ir the url:" . $url, 401);
        }

		$url = env('APP_FOLIATTIAPI_URL') . "Player/getCuentaJugador?AppId=" . $id . "&CasinoId=" . $request->input('idsucursal');//Catalogs/getPaises
		$method="GET";
		$output = (new Tools)->CallAPI($method, $url);

		$result = json_decode($output);
		
		return $result;	
	}



    function registrarClienteFoliatti(Request $request, $id)
    {
        try {
            $this->validate($request, [
//'idgenero' => 'required',
//'idestadocivil' => 'required',
//'idpais_nacimiento' => 'required', 
//'idpais_nacionalidad' => 'required', 
//'curp' => 'required', 
//'rfc' => 'required', 
//'calle' => 'required', 
//'numero_exterior' => 'required', 
//'numero_interior' => 'required', 
//'colonia' => 'required', 
//'codigo_postal' => 'required', 
//'idmunicipio' => 'required', 
//'idestado' => 'required', 
//'idtipoidentificacion' => 'required', 
//'numero_id' => 'required', 
//'vigencia_id' => 'required', //yyyy-mm-dd
//'foto_id_frente' => 'required', 
//'foto_id_reverso' => 'required', 

			
			/*|unique:clientes*/

                //'AppSignature' => 'required'
            ]);

			//$cliente = $this->clienteRepository->findWithoutFail($id);
            $cliente = Cliente::where('id', $id)->firstOrFail();
			

            
/*
idsucursal ***
idgenero
idestadocivil
idpais_nacimiento
idpais_nacionalidad
curp
rfc

calle
numero_exterior
numero_interior
colonia


codigo_postal
idmunicipio
idestado
idciudad


idtipoidentificacion
numero_id
vigencia_id //formato yyyy-mm-dd
foto_id_frente //requerida, Base64 (como las fotos del valet parking auto)
foto_id_reverso //requerida, Base64 (como las fotos del valet parking auto)


*/

/*


{
  "appId": 1,
  "id_sucursal": 1,
  "datos_basicos": {
    "nombre": "Jose",
    "apellido_paterno": "Gonzalez",
    "apellido_materno": "Mendoza",
    "celular": "8145789565",
    "telefono": "8101010101",
    "id_genero": 2,
    "id_estado_civil": 2,
    "fecha_nacimiento": "1990-04-25",
    "id_pais_nacimiento": 484,
    "id_pais_nacionalidad": 484,
    "correo": "correodeejemplo@email.com",
    "curp": "GOMJ900425HNLNRS01",
    "rfc": "GOMJ900425RS5"
  },
  "domicilio_actual": {
    "calle": "Ruperto Martinez",
    "num_extrerior": "1845",
    "num_interior": "45B",
    "colonia": "Mitras",
    "ciudad": "Monterrey",
    "id_municipio": 484019039,
    "id_estado": 484019,
    "codigo_postal": "85974",
    "referencia": "Entre calle uno y Av. las Americas"
  },
  "comprobacion_identidad": {
    "tipo_id": 1,
    "numero_id": "0001454572574",
    "vigencia_id": "2025-01-31",
    "foto_id_frente": "",
    "foto_id_reverso": ""
  }
}


*/

$data= array(
    'appId'=> $id,
    'id_sucursal'=>$request->input('idsucursal'),
    'datos_basicos' =>
    array(
        'nombre'=> $cliente->nombre,
        'apellido_paterno'=> $cliente->apellido_paterno,
        'apellido_materno'=> $cliente->apellido_materno,
        'celular'=> $cliente->celular,
        'telefono'=> $cliente->celular,
        'id_genero'=> $request->input('idgenero'),
        'id_estado_civil'=> $request->input('idestadocivil'),
        'fecha_nacimiento'=> $cliente->fecha_nacimiento,
        'id_pais_nacimiento'=> $request->input('idpais_nacimiento'),
        'id_pais_nacionalidad'=> $request->input('idpais_nacionalidad'),
        'correo'=> $cliente->email,
        'curp'=> $request->input('curp'),
        'rfc'=> $request->input('rfc')
    ),
    'domicilio_actual' =>
    array(
        'calle' =>$request->input('calle'), 
        'num_extrerior' =>$request->input('numero_exterior'), 
        'num_interior' =>$request->input('numero_interior'), 
        'colonia' =>$request->input('colonia'), 
        'ciudad' =>$request->input('municipio_nombre'), 
        'id_municipio' =>$request->input('idmunicipio'), 
        'id_estado' =>$request->input('idestado'), 
        'codigo_postal' =>$request->input('codigo_postal'), 
        'referencia' => '' 
    ),
    'comprobacion_identidad' =>
    array (
        'tipo_id' => $request->input('idtipoidentificacion'),
        'numero_id' => $request->input('numero_id'),
        'vigencia_id' => $request->input('vigencia_id'),
        'foto_id_frente' => $request->input('foto_id_frente'),
        'foto_id_reverso' => $request->input('foto_id_reverso')
    )

);
    /*
    $ack_code = 400;
    if(true)
    {
        return response()->json(['data'=>$data ], $ack_code);  
    }
*/
    $url = env('APP_FOLIATTIAPI_URL') . "Player/registrarClienteNuevo";
    $method="POST";
    $output = (new Tools)->CallAPI($method, $url, json_encode($data));
    $result = json_decode($output);
    $ack_code = 200;//
    $myAck_code = (int)$result->ack_code;//$result->ack_code;

    $message = "";
    if($myAck_code != 100) //Error
    {
        switch ($myAck_code)
        {
            case 400    :
                $message = "Ocurrió un error al procesar la solicitud";           
                break;
            case 401:
                $message = "No autorizado para acceder al recurso.";           
                break;
            default:
                $message = $result->errors;           
        }

        //return $this->sendError(['text'=>'Cliente no se pudo vincular:' . 'No se encontró ninguna cuenta con los datos proporcionados en la sucursal seleccionada.', 'ack_code'=> 503], 503);    
            return response()->json([/*'ack_code'=> $myAck_code, 'output'=>$output,*/ 'success'=> false, 'message'=>$message, 'ack_code'=> $myAck_code, 'data'=>$data ], 401);                
    }
    else
    {

        $cliente->registradofoliatti = true;
        $cliente->save();
        
        return response()->json([/*'ack_code'=> $myAck_code,'result'=>$result,'output'=>$output, */'success'=> true, 'message'=>$message, 'ack_code'=> $myAck_code, 'data'=>$data ], 401);  
    }




/*
            $codigo = mt_rand(0, 999999);
            $cliente = new Cliente;
            $cliente->codigo = $codigo;
            $cliente->celular = $request->input('celular');
            $cliente->email = $request->input('email');

            $cliente->password = Hash::make($request->input('password'));
            $cliente->device_token = $request->input('device_token', '');
            $cliente->api_token = Str::random(60);
            
            $url = "https://apps.ecdevelopment.mx/SmsEngine/Services/SmsEngine.svc/SMSRequest";
            $response = Http::post($url, [
                "security" => [
                    "AppId" => 6,
                    "Time" => "1634093106",
                    "Hash" => "41d7c1734734ff80b12d02a3a961af51"
                ],
                    "message" => [
                        "SiteId" => "SMS",
                        "Cellphone" => $request->input('celular'),
                        "Message"=> "Tu codigo de verificacion es: $codigo $appSignature"
                        ]
            ]);
            $cliente->save();
*/


        } catch (\Exception $e) {
            //Log::error($e->getMessage());
            return $this->sendError("No está jalando:" . $e->getMessage(), 401);
        }


        return $this->sendResponse($cliente, 'Cliente registrado en Sistema Foliatti:');
    }


    function validarVinculacionCliente(Request $request, $id)
	{
        //$cliente = $this->clienteRepository->findWithoutFail($id);
        $cliente = Cliente::where('id', $id)->firstOrFail();

		if($cliente->vinculado)
		{
            return $this->sendResponse($cliente, 'Cliente vinculado');
        } else {
            return $this->sendError('Cliente no vinculado', 401);
        }
    }

    function validarCliente(Request $request, $id){
        //$cliente = $this->clienteRepository->findWithoutFail($id);
        $cliente = Cliente::where('id', $id)->firstOrFail();
        $this->validate($request, [
            'codigo' => 'required',
            'IsAdult' => 'required',
        ]);
        if($cliente->codigo == $request->input('codigo')){
            $this->clienteRepository->update(array(
                'IsAdult' => $request->input('IsAdult'),
                'status' => 1,
            ), $id);
            return $this->sendResponse($cliente, 'Cliente validado con exito');
        } else {
            return $this->sendError('Codigo incorrecto', 401);
        }
    }

    function updateClienteSucursalFavorita(Request $request, $idcliente)
    {
        $cliente = $this->clienteRepository->findWithoutFail($idcliente);
        //$cliente = DB::table('clientes')->where('id', $idcliente)->first();

        try
        {
        $this->validate($request, [
            'idsucursal' => 'required',
        ]);

        $idsucursal = $request->input('idsucursal');
        $cliente->idsucursal = $idsucursal;
        $cliente->save();

        DB::table('cliente_sucursal')
        ->where('idcliente', $idcliente)
        ->update(['favorito' => false]);

        DB::table('cliente_sucursal')
        ->where('idcliente', $idcliente)
        ->where('idsucursal', $idsucursal)
        ->update(['favorito' => true]);

        return $this->sendResponse($cliente, 'Cliente actualizado con éxito');
        }  
        catch(\Exception $excep)
        {
            return $this->sendError($excep->getMessage() . 'No se pudo actualizar la sucursal favorita', 401);
        }
    }    

    function reenviarCodigoSMSCliente(Request $request, $id)
	{
        //$cliente = $this->clienteRepository->findWithoutFail($id);
        $cliente = Cliente::where('id', $id)->firstOrFail();


		if(true)
		{
            return $this->sendResponse($cliente, 'Código reenviado exitosamente');
        } else {
            return $this->sendError('No pudo enviarse el código', 401);
        }
    }

    function reenviarCodigoEmailCliente(Request $request, $id)
	{
        //$cliente = $this->clienteRepository->findWithoutFail($id);
        $cliente = Cliente::where('id', $id)->firstOrFail();
        

        // Multiple recipients
        $to = $cliente->email;

        // Subject
        $subject = 'Bienvenido a Foliatti';

        // Message
$message = '
<html>
<head>
  <title>Bienvenido a Foliatti</title>
</head>
<body>
Bienvenido a Foliatti. Tu c&oacute;digo de verificaci&oacute;n es: ' . $cliente->codigo . '
</body>
</html>
';

// To send HTML mail, the Content-type header must be set
$headers[] = 'MIME-Version: 1.0';
$headers[] = 'Content-type: text/html; charset=iso-8859-1';

// Additional headers
//$headers[] = 'To: Mary <mary@example.com>, Kelly <kelly@example.com>';
$headers[] = 'From: FoliattiApp <foliattiapp@innovationti.mx>';
//$headers[] = 'Cc: birthdayarchive@example.com';
//$headers[] = 'Bcc: birthdaycheck@example.com';

// Mail it
mail($to, $subject, $message, implode("\r\n", $headers));


		if(true)
		{
            return $this->sendResponse($cliente, 'Código reenviado exitosamente');
        } else {
            return $this->sendError('No pudo enviarse el código', 401);
        }
    }

    

    function getClienteSucursales(Request $request, $id)
	{
        //$cliente = $this->clienteRepository->findWithoutFail($id);

        $cliente = Cliente::where('id', $id)->firstOrFail();

        $clientesucursales = ClienteSucursal::where('idcliente',$id)->get();
        $clientesucursales = ClienteSucursal::select("sucursal.nombre as sucursal_nombre")
        ->join("sucursal","sucursal.id","=","cliente_sucursal.idsucursal");

/*->where('tripplan.created_by',$personid)->orWhere('tripplan.requesterid',$personid);
->where(function ($query) use ($personid){
    $query->where('tripplan.created_by',$personid)->orWhere('tripplan.requesterid',$personid);
})
->orderBy("tripplan.id", "desc");
*/


        /*$clientesucursales = DB::table('cliente_sucursal')
            ->join('sucursal', 'cliente_sucursal.idsucursal', '=', 'sucursal.id')
            ->where('cliente_sucursal.idcliente',$id)
            ->select('cliente_sucursal.idsucursal', 'sucursal.nombre as sucursal_nombre', 'sucursal.id as idsucursal', 'sucursal.codigo as sucursal_codigo')->get();

*/

		if($clientesucursales != null)
		{
            return $this->sendResponse($cliente->cliente_sucursal, 'Sucursales del Cliente');
        } else {
            return $this->sendError('El cliente no tiene sucursales vinculadas', 401);
        }
    }




    public function getCuentaJugador(Request $request, $id)
    {

        $url = env('APP_FOLIATTIAPI_URL') . "Player/getCuentaJugador?AppId=" . $id . "&CasinoId=" . $request->input('idsucursal');
		$method="GET";
		$output = (new Tools)->CallAPI($method, $url);
		$result = json_decode($output);
        
        $ack_code = $result->ack_code;

        $message = "";
        if($ack_code != 200) //Error
        {
            switch ($ack_code)
            {
                case 400:
                    $message = "Ocurrió una excepción al procesar la solicitud.";           
                    break;
                case 401:
                    $message = "No autorizado para acceder al recurso.";           
                    break;
                default:
                    $message = "";           
            }

            return response()->json(['success'=> false, 'message'=>$message, 'ack_code'=> $ack_code ], $ack_code);                
        }





        $municipios = $result->municipios;
        if($municipios != null)
        {

            foreach ($municipios as &$municipio) 
            {
                try
                {
                    $municipioToInsert = new Municipio;
                    $municipioToInsert->id = $municipio->id;
                    $municipioToInsert->idestado = $municipio->id_estado;
                    $municipioToInsert->nombre = $municipio->nombre;
                    $municipioToInsert->codigo = $municipio->id;
                    $municipioToInsert->activo = true;
                    $municipioToInsert->save();
                }
			    catch(\Exception $excep)
		    	{
                    return $this->sendError($excep->getMessage(), 404);
   
                }



            }
        }


        return $this->sendResponse($result->municipios[0]->id . $result->municipios[0]->nombre . $result->municipios[0]->id, 401);

    }    



    function vincularCliente(Request $request, $id)
	{
        //$cliente = $this->clienteRepository->findWithoutFail($id);
        $cliente = Cliente::where('id', $id)->firstOrFail();

		$this->validate($request, [
            'idsucursal' => 'required',
        ]);

        $idsucursal = $request->input('idsucursal');

//Checando si hay registros del usuario en Foliatti
//https://144.217.254.104/FoliattiApp/api/v1/Player/getJugadorByAppId?AppId=1

/*$url = env('APP_FOLIATTIAPI_URL') . "Player/getJugadorByAppId?AppId=" . $id;
$method="GET";
$output = (new Tools)->CallAPI($method, $url);
$result = json_decode($output);

        $cuenta = $result->cuenta;
*/


        /*$cuenta->appellido_paterno;
        $cuenta->appellido_materno;
        $cuenta->celular;
        $cuenta->fecha_nacimiento;
        $cuenta->curp;
        */
        //$sucursales = $cuenta->sucursales_vinculadas;       

        $data= array(
            'appId'=> $id,
            'nombre'=> $cliente->nombre,
            'apellido_paterno'=> $cliente->apellido_paterno,
            'apellido_materno'=> $cliente->apellido_materno,
            'celular'=> $cliente->celular,
            'correo'=> $cliente->email,
            'fecha_nacimiento'=> $cliente->fecha_nacimiento,
            'id_sucursal'=> $idsucursal
          );
          

            $url = env('APP_FOLIATTIAPI_URL') . "Player/vincularCuenta";
            $method="POST";
            $output = (new Tools)->CallAPI($method, $url, json_encode($data));
            $result = json_decode($output);
            $ack_code = $result->ack_code;

            $message = "";
            if($ack_code != 100) //Error
            {
                switch ($ack_code)
                {
                    case 499:
                        $message = "Se recibió una solicitud vacía, favor de validar el formato de su solicitud.";           
                        break;
                    case 500:
                        $message = "Ocurrió un error al procesar la solicitud";           
                        break;
                    case 501:
                        $message = "El jugador ya tiene una cuenta ligada en la sucursal seleccionada";           
                        break;
                    case 502:
                        $message = "Los datos del jugador no coinciden con los registrados en la sucursal seleccionada.";           
                        break;
                    case 503:
                        $message = "No se encontró ninguna cuenta con los datos proporcionados en la sucursal seleccionada.";           
                        break;
                    case 504:
                        $message = "Se encontró mas de una cuenta en la sucursal seleccionada.";           
                        break;
                    case 505:
                        $message = "El numero celular ya esta registrado con otro usuario.";           
                        break;
                    default:
                        $message = "";           
                }

                $cliente->vinculado = true;
                $cliente->save();

                //return $this->sendError(['text'=>'Cliente no se pudo vincular:' . 'No se encontró ninguna cuenta con los datos proporcionados en la sucursal seleccionada.', 'ack_code'=> 503], 503);    
                    return response()->json(['success'=> false, 'message'=>$message, 'ack_code'=> $ack_code , 'data'=> $data], $ack_code);                
            }




		$clientesucursal = new ClienteSucursal;
		$clientesucursal->idcliente = $id;
		$clientesucursal->idsucursal = $idsucursal;
		$clientesucursal->fechavinculacion = '2022-08-01 14:56:00';
		$clientesucursal->save();
		
        $clientesucursales = ClienteSucursal::where('idcliente',$id)->get();

/*
		// create & initialize a curl session
$curl = curl_init();

// set our url with curl_setopt()
curl_setopt($curl, CURLOPT_URL, env('APP_FOLIATTIAPI_URL') + "Player/getJugadorByAppId?AppId=121");

// return the transfer as a string, also with setopt()
curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

// curl_exec() executes the started curl session
// $output contains the output string
$output = curl_exec($curl);

// close curl resource to free up system resources
// (deletes the variable made by curl_init)
curl_close($curl);
*/

        if($clientesucursales == null)
    	{
            $cliente->vinculado = false;
        }
        else
        {
            $cliente->vinculado = true;
        }
        
		if($cliente->vinculado)
		{
            return $this->sendResponse($cliente->cliente_sucursal, 'Cliente vinculado exitosamente');
        } else {
            return $this->sendError('Cliente no se pudo vincular:' . $clientesucursales, 401);
        }
    }


    function checkCliente(Request $request, $id)
	{
        //$cliente = $this->clienteRepository->findWithoutFail($id);
        $cliente = Cliente::where('id', $id)->firstOrFail();

	
		// create & initialize a curl session
$curl = curl_init();

// set our url with curl_setopt()
curl_setopt($curl, CURLOPT_URL, "https://144.217.254.104/FoliattiApp/api/v1/Player/getJugadorByAppId?AppId=121");

curl_setopt($curl, CURLOPT_HEADER, TRUE);

// return the transfer as a string, also with setopt()
curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

// curl_exec() executes the started curl session
// $output contains the output string
$output = curl_exec($curl);


// close curl resource to free up system resources
// (deletes the variable made by curl_init)
curl_close($curl);


		
		$cliente->vinculado = true;

		if($cliente->vinculado)
		{
            return $this->sendResponse($cliente, 'CHECK' . $output . "//END");
        } else {
            return $this->sendError('NO CHECK', 401);
        }
    }


    function validarCliente2(Request $request, $id){
        //$cliente = $this->clienteRepository->findWithoutFail($id);
        $cliente = Cliente::where('id', $id)->firstOrFail();
        $this->validate($request, [
            'codigo' => 'required',
            'IsAdult' => 'required',
        ]);
        if($cliente->codigo == $request->input('codigo')){
            $this->clienteRepository->update(array(
                'IsAdult' => $request->input('IsAdult'),
                'status' => 1,
            ), $id);
            return $this->sendResponse($cliente, 'Cliente validado con exito');
        } else {
            return $this->sendError('Codigo incorrecto', 401);
        }
    }


    public function getCliente($telefono){
        $cliente = Cliente::where('celular',$telefono)->get();
            if ($cliente->count() == 0) {
                try {
                    $password = mt_rand(0, 999999);
                    $cliente = new Cliente;
                    $cliente->celular = $telefono;
                    $cliente->password = Hash::make($password);
                    $cliente->api_token = Str::random(60);
                    
                    $url = "https://apps.ecdevelopment.mx/SmsEngine/Services/SmsEngine.svc/SMSRequest";
                    Http::post($url, [
                        "security" => [
                            "AppId" => 6,
                            "Time" => "1634093106",
                            "Hash" => "41d7c1734734ff80b12d02a3a961af51"
                        ],
                        "message" => [
                            "SiteId" => "SMS",
                            "Cellphone" => $telefono,
                            "Message"=> "Has sido registrado bienvenido. Inicia sesion con el numero de tu telefono y tu contrasena es: $password"
                        ]
                    ]);
                    $cliente->save();
					$clientenuevo[0] = $cliente;
                    return $this->sendResponse($clientenuevo, 'Registrado con exito');
                } catch (\Exception $e) {
                    //Log::error($e->getMessage());
                    return $this->sendError($e->getMessage(), 401);
                }
            }else {
                return $this->sendResponse($cliente, 'Cliente encontrado con exito');
            }  
    }
    
    public function actualizarCliente(Request $request, $telefono){
        try{
            $this->validate($request, [
                    'password' => 'required',
            ]);
            $cliente = Cliente::where('celular', $telefono)->first();
            $codigo = mt_rand(100000, 999999);
            $cliente->codigo = $codigo;
            $cliente->password = $request->has('password') ? bcrypt($request->get('password')) : $cliente->password;
            $cliente->status = 0;
            $url = "https://apps.ecdevelopment.mx/SmsEngine/Services/SmsEngine.svc/SMSRequest";
                $response = Http::post($url, [
                    "security" => [
                        "AppId" => 6,
                        "Time" => "1634093106",
                        "Hash" => "41d7c1734734ff80b12d02a3a961af51"
                    ],
                        "message" => [
                            "SiteId" => "SMS",
                            "Cellphone" => $telefono,
                            "Message"=> "Tu codigo de verificacion es: $codigo"
                            ]
                ]);
            $cliente->save();
            return $this->sendResponse($cliente, 'Cliente actualizado con exito');
        } catch (\Exception $e) {
            return $this->sendError($e->getMessage(), 401);
        }    
    }



    public function actualizarFirebaseTokenCliente(Request $request, $id)
    {
        try{
            $this->validate($request, [
                    'firebase_token' => 'required',
            ]);

            //$cliente = $this->clienteRepository->findWithoutFail($id);
            $cliente = Cliente::where('id', $id)->firstOrFail();

            $cliente->firebase_token = $request->get('firebase_token');
            $cliente->save();

            return $this->sendResponse($cliente, 'Cliente actualizado con éxito');
        } catch (\Exception $e) {
            return $this->sendError($e->getMessage(), 401);
        }    
    }


    public function actualizarFullCliente(Request $request, $id)
	{
        try
		{
            $nombre = $request->input('nombre');
			$apellido_paterno = $request->input('apellido_paterno');
			$apellido_materno = $request->input('apellido_materno');
			$fecha_nacimiento = $request->input('fecha_nacimiento'); //yyyy-mm-dd


			//$cliente = $this->clienteRepository->findWithoutFail($id);
            $cliente = Cliente::where('id', $id)->firstOrFail();

            $cliente->nombre = $nombre;
			$cliente->apellido_paterno = $apellido_paterno;
			$cliente->apellido_materno = $apellido_materno;
			$cliente->fecha_nacimiento = $fecha_nacimiento;


            $cliente->save();
            return $this->sendResponse($cliente, 'Cliente actualizado con éxito');
        } catch (\Exception $e) {
            return $this->sendError($e->getMessage(), 401);
        }    
    }


    public function actualizarPasswordCliente(Request $request, $id)
	{
        try
		{
            $password = $request->input('password');
			$new_password = $request->input('new_password');
			//$cliente = $this->clienteRepository->findWithoutFail($id);
            $cliente = Cliente::where('id', $id)->firstOrFail();

            if (Auth::guard('clientes')->attempt(['celular' => $cliente->celular, 'password' => $request->input('password')])) {
                // Authentication passed...
                $clienteToEdit = Auth::guard('clientes')->user();
                $cliente->password = Hash::make($new_password);
                $cliente->save();
                return $this->sendResponse($cliente, 'Contraseña actualizada exitosamente');
            } else {
                return $this->sendError('La contraseña anterior es incorrecta', 401);
            }

            
        } catch (\Exception $e) {
            return $this->sendError($e->getMessage(), 401);
        }    
    }


    function verificarServicioDepositosClienteFoliatti(Request $request, $id)
    {
        try 
        {
            $this->validate($request, [
            ]);

            $cliente = Cliente::where('id', $id)->firstOrFail();
			$cliente->registradofoliatti = true;

                        /*

                        {
            "appId": 289,
            "id_tipo_cuenta": 2,
            "id_sucursal": 1,
            "referencia_externa": "15f792c7cd544f1d894df746f491683e",
            "monto": 150
            }
            
                        */

            $data= array(
                'appId'=> $id,
                'id_tipo_cuenta'=>'1',
                'id_sucursal'=>$request->input('idsucursal'),
                'referencia_externa'=>(new Tools)->generateUUID(),
                'monto'=>$request->input('monto')
            );

            $url = env('APP_FOLIATTIAPI_URL') . "Deposit/solicitarDeposito";
            $method="POST";
            $output = (new Tools)->CallAPI($method, $url, json_encode($data));
            $result = json_decode($output);
            $ack_code = 200;//
//            $myAck_code = (int)$result->ack_code;//$result->ack_code;

        return response()->json($result);




        } catch (\Exception $e) {
            //Log::error($e->getMessage());
            return $this->sendError("No está jalando:" . $e->getMessage(), 401);
        }


        return $this->sendError('Cliente NO registrado en Sistema Foliatti:');
    }    

    
    function verificarServicioDepositosClienteFoliatti_Deprecated(Request $request, $id)//Deprecated 28/07/2024
    {
        try {
            $this->validate($request, [
//'idgenero' => 'required',

            ]);

			//$cliente = $this->clienteRepository->findWithoutFail($id);
            $cliente = Cliente::where('id', $id)->firstOrFail();
			$cliente->registradofoliatti = true;

            

$data= array(
    'appId'=> $id,
    'id_sucursal'=>$request->input('idsucursal')
);

/*
    $ack_code = 400;
    if(true)
    {
        return response()->json(['data'=>$data ], $ack_code);  
    }
*/
    $url = env('APP_FOLIATTIAPI_URL') . "Deposit/verificarServicioDepositos";
    $method="POST";
    $output = (new Tools)->CallAPI($method, $url, json_encode($data));
    $result = json_decode($output);
    $ack_code = 200;//
    $myAck_code = (int)$result->ack_code;//$result->ack_code;

    $message = "Operación realizada con éxito";
    if($myAck_code != 100) //Error
    {
        switch ($myAck_code)
        {
            case 400    :
                $message = "Ocurrió un error al procesar la solicitud";           
                break;
            case 401:
                $message = "No autorizado para acceder al recurso.";           
                break;
            default:
                $message = $result->errors;           
        }

            return response()->json([/*'ack_code'=> $myAck_code, 'output'=>$output,*/ 'success'=> false, 'message'=>$message, 'ack_code'=> $myAck_code, 'data'=>$data ], 401);                
    }
    else
    {

        return response()->json([/*'ack_code'=> $myAck_code,'result'=>$result,'output'=>$output, */'success'=> true, 'message'=>$message, 'ack_code'=> $myAck_code, 'data'=>$data ], 401);  
    }




        } catch (\Exception $e) {
            //Log::error($e->getMessage());
            return $this->sendError("No está jalando:" . $e->getMessage(), 401);
        }


        return $this->sendResponse($cliente, 'Cliente registrado en Sistema Foliatti:');
    }    



    function recargaSaldoClienteFoliatti(Request $request, $id)
    {
        try 
        {
            $this->validate($request, [

			
			/*|unique:clientes*/

                //'AppSignature' => 'required'
            ]);

			//$cliente = $this->clienteRepository->findWithoutFail($id);
            $cliente = Cliente::where('id', $id)->firstOrFail();

			$cliente->registradofoliatti = true;

            $data= array(
                'appId'=> $id,
                'id_sucursal'=>$request->input('idsucursal'),
            );


            $url = env('APP_FOLIATTIAPI_URL') . "Deposit/verificarServicioDepositos";
//            echo $url;

            $method="POST";
            $output = (new Tools)->CallAPI($method, $url, json_encode($data));

//            echo var_dump($data);

            $result = json_decode($output);
            $ack_code = 200;//
            $myAck_code = (int)$result->ack_code;//$result->ack_code;

            return response()->json($result);

        } catch (\Exception $e) 
        {
                //Log::error($e->getMessage());
                return $this->sendError("No está jalando:" . $e->getMessage(), 401);
        }

    }

    function recargaSaldoClienteFoliatti_Deprecated(Request $request, $id) //DECRECATED
    {
        try {
            $this->validate($request, [

			
			/*|unique:clientes*/

                //'AppSignature' => 'required'
            ]);

			//$cliente = $this->clienteRepository->findWithoutFail($id);
            $cliente = Cliente::where('id', $id)->firstOrFail();
			$cliente->registradofoliatti = true;

/*
{
  "appId": 266,
  "id_tipo_cuenta": 1,
  "id_sucursal": 1,
  "id_transaccion": "1001",
  "monto": 5000,
  "no_tarjeta": "ELX7bpZtZenjmOm2ghNGWE+APCPkX7u4hoGdfudU748rPqlo1em5cMMB1IpqIBSq",
  "fecha_expiracion": "Q63EzQzzTOn/WLqUEiAYrGuzcC69/bV2fWfutgJSOrE=",
  "codigo": "w13wazvQmdAOUJbSrhEBN8bCwROQ/DuoYCb5Z5oDI2A="
}
*/

$data= array(
    'appId'=> $id,
    'id_sucursal'=>$request->input('idsucursal'),
    'id_tipo_cuenta'=> $request->input('id_tipo_cuenta'),
    'referencia_externa'=> $request->input('referencia_externa'),
    'monto'=> $request->input('monto'),
    'no_tarjeta'=> $request->input('no_tarjeta'),
    'fecha_expiracion'=> $request->input('fecha_expiracion'),
    'codigo'=> $request->input('codigo')
);


    $url = env('APP_FOLIATTIAPI_URL') . "Deposit/solicitarDeposito";
    $method="POST";
    $output = (new Tools)->CallAPI($method, $url, json_encode($data));
    $result = json_decode($output);
    $ack_code = 200;//
    $myAck_code = (int)$result->ack_code;//$result->ack_code;

    return response()->json($result);



        } catch (\Exception $e) {
            //Log::error($e->getMessage());
            return $this->sendError("No está jalando:" . $e->getMessage(), 401);
        }


    }

    
private function getBytesFromHexString($hexdata)
{
  for($count = 0; $count < strlen($hexdata); $count+=2)
    $bytes[] = chr(hexdec(substr($hexdata, $count, 2)));

  return implode($bytes);
}

private function getImageMimeType(string $encodedImage)
{
    $decodedImage = base64_decode($encodedImage);
    return (explode('/', finfo_buffer(finfo_open(), $decodedImage, FILEINFO_MIME_TYPE))[1]);
}

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function actualizarFotoPerfil(Request $request, $idcliente)
    {
        $this->validate($request, [
            'img_profile' => 'required',
        ]);

        $cliente = $this->clienteRepository->findWithoutFail($idcliente);
//        return $this->sendResponse($cliente, utf8_encode('Foto de perfil actualizada correctamente'));

        $definedDisk = "promocion";
		$imagesPath = "/storage/clientes/" . $idcliente . "/";

        try {

            $img_profile = $request->img_profile;
			if($img_profile != null)
			{
				try
				{
					$img_profile = getB64Image($request->img_profile);
                    //$img_extension = pathinfo($request->img_profile, PATHINFO_EXTENSION);//$this->getImageMimeType($request->img_profile);//explode('/', mime_content_type($request->img_profile))[1];

                    $imgdata = base64_decode($request->img_profile);
                    $f = finfo_open();
                    $mime_type = finfo_buffer($f, $imgdata, FILEINFO_MIME_TYPE);

                    $split = explode('/', $mime_type);
                    $img_extension = $split[1];



					//$img_extension = getB64Extension($request->img_profile);
					$img_name_profile = 'img_profile_'. time() . '.' . $img_extension;
					//Storage::disk($definedDisk)->put($idcliente . '/' . $img_name_profile, $img_profile);

                    //Storage::disk('promocion')->put($oPromocion->id . '/' .$imagen_mini_name, $imagen_mini);

                    //Storage::disk('')->put(1 . '/' .'temporal250523', $img_profile);
                    Storage::disk('cliente')->put($idcliente . '/' . $img_name_profile, $img_profile);

                    $cliente->img_profile = env('APP_FOLIATTI_IMG_PATH') . 'clientes/' . $idcliente . '/' .   $img_name_profile;


				}
				catch (Exception $eimage)
				{
                    return $this->sendError($eimage->getMessage(), '401');
				}
			}
			else
			{
				$cliente->$img_profile = "error";
			}






            $cliente->save();



            

        } catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($cliente, utf8_encode('Foto de perfil actualizada correctamente'));
    }
    

}